/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.corelib.client.PlayerSkins;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.entities.DummyPlayerRenderer;
import de.maxhenkel.corpse.entities.DummySkeleton;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity> {
    private final CachedMap<CorpseEntity, DummyPlayer> players = new CachedMap(10000L);
    private final CachedMap<CorpseEntity, DummySkeleton> skeletons = new CachedMap(10000L);
    private final DummyPlayerRenderer playerRenderer;
    private final DummyPlayerRenderer playerRendererSmallArms;
    private final SkeletonRenderer skeletonRenderer;

    public CorpseRenderer(EntityRendererProvider.Context renderer) {
        super(renderer);
        this.playerRenderer = new DummyPlayerRenderer(renderer, false);
        this.playerRendererSmallArms = new DummyPlayerRenderer(renderer, true);
        this.skeletonRenderer = new SkeletonRenderer(renderer);
    }

    public ResourceLocation getTextureLocation(CorpseEntity entity) {
        return null;
    }

    public void render(CorpseEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-entity.m_146908_()));
        if (((Boolean)Main.SERVER_CONFIG.spawnCorpseOnFace.get()).booleanValue()) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrixStack.m_85837_(0.0, -1.0, -0.125625);
        } else {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            matrixStack.m_85837_(0.0, -1.0, 0.125625);
        }
        if (entity.isSkeleton()) {
            DummySkeleton skeleton = this.skeletons.get(entity, () -> new DummySkeleton(entity.f_19853_, entity.getEquipment()));
            this.skeletonRenderer.m_7392_((Mob)skeleton, entityYaw, 1.0f, matrixStack, buffer, packedLightIn);
        } else {
            AbstractClientPlayer abstractClientPlayerEntity = (AbstractClientPlayer)this.players.get(entity, () -> new DummyPlayer((ClientLevel)entity.f_19853_, new GameProfile(entity.getCorpseUUID().orElse(new UUID(0L, 0L)), entity.getCorpseName()), entity.getEquipment(), entity.getCorpseModel()));
            if (PlayerSkins.isSlim(entity.getCorpseUUID().orElse(new UUID(0L, 0L)))) {
                this.playerRendererSmallArms.m_7392_(abstractClientPlayerEntity, 0.0f, 1.0f, matrixStack, buffer, packedLightIn);
            } else {
                this.playerRenderer.m_7392_(abstractClientPlayerEntity, 0.0f, 1.0f, matrixStack, buffer, packedLightIn);
            }
        }
        matrixStack.m_85849_();
    }
}

