/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.integration.waila;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class HUDHandlerCorpse
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    public static final HUDHandlerCorpse INSTANCE = new HUDHandlerCorpse();

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity;
            if (entityAccessor.getTooltipPosition().equals((Object)TooltipPosition.BODY)) {
                Death death;
                long timestamp;
                CompoundTag data = entityAccessor.getServerData();
                if (data.m_128441_("Death") && (timestamp = (death = Death.fromNBT(data.m_128469_("Death"))).getTimestamp()) > 0L) {
                    iTooltip.add((Component)new TranslatableComponent("tooltip.corpse.death_date", new Object[]{DeathHistoryScreen.getDate(timestamp)}));
                }
                if (data.m_128441_("ItemCount")) {
                    iTooltip.add((Component)new TranslatableComponent("tooltip.corpse.item_count", new Object[]{data.m_128451_("ItemCount")}));
                }
            } else if (entityAccessor.getTooltipPosition().equals((Object)TooltipPosition.HEAD)) {
                iTooltip.remove(OBJECT_NAME_TAG);
                iTooltip.add((Component)new TextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getBlockName(), corpse.m_5446_().getString())).m_130940_(ChatFormatting.WHITE));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, Entity entity, boolean b) {
        Entity entity2 = entity;
        if (entity2 instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity2;
            Death death = corpse.getDeath();
            compoundTag.m_128365_("Death", (Tag)death.toNBT(false));
            compoundTag.m_128405_("ItemCount", (int)death.getAllItems().stream().filter(itemStack -> !itemStack.m_41619_()).count());
        }
    }
}

