/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.gui.Guis;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageShowCorpseInventory
implements Message {
    private UUID playerUUID;
    private UUID deathID;

    public MessageShowCorpseInventory() {
    }

    public MessageShowCorpseInventory(UUID playerUUID, UUID deathID) {
        this.playerUUID = playerUUID;
        this.deathID = deathID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        Guis.openCorpseGUI(context.getSender(), this.playerUUID, this.deathID);
    }

    public MessageShowCorpseInventory fromBytes(FriendlyByteBuf buf) {
        this.playerUUID = new UUID(buf.readLong(), buf.readLong());
        this.deathID = new UUID(buf.readLong(), buf.readLong());
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeLong(this.playerUUID.getMostSignificantBits());
        buf.writeLong(this.playerUUID.getLeastSignificantBits());
        buf.writeLong(this.deathID.getMostSignificantBits());
        buf.writeLong(this.deathID.getLeastSignificantBits());
    }
}

