/*
 * Decompiled with CFR 0.152.
 */
package net.mobz;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.mobz.item.SpawnEgg;

public interface IRegistryWrapper {
    public CreativeModeTab tab(ResourceLocation var1, Supplier<ItemStack> var2);

    public Item register(String var1, Item var2);

    public BlockItem register(String var1, BlockItem var2);

    default public BlockItem register(String name, Block block, CreativeModeTab group) {
        return this.register(name, new BlockItem(block, new Item.Properties().m_41491_(group)));
    }

    default public BlockItem register(String name, Block block, CreativeModeTab group, int maxStackSize) {
        return this.register(name, new BlockItem(block, new Item.Properties().m_41491_(group).m_41487_(maxStackSize)));
    }

    public <T extends Entity> EntityType<T> register(String var1, EntityType<T> var2);

    public <T extends LivingEntity> EntityType<T> entityAttribModifier(EntityType<T> var1, Supplier<AttributeSupplier.Builder> var2);

    default public <T extends LivingEntity> void register(String name, EntityType<T> entityType, @Nullable Supplier<AttributeSupplier.Builder> attribModifierSupplier, @Nullable SpawnEggItem spawnEggItem) {
        this.register(name, entityType);
        if (spawnEggItem != null) {
            this.register("spawn_" + name, (Item)spawnEggItem);
        }
        if (attribModifierSupplier != null) {
            this.entityAttribModifier(entityType, attribModifierSupplier);
        }
    }

    default public <T extends Mob> void register(String name, EntityType<T> entityType, Supplier<AttributeSupplier.Builder> attribModifierSupplier, int eggColor1, int eggColor2, CreativeModeTab eggGroup) {
        this.register(name, entityType, attribModifierSupplier, new SpawnEgg(entityType, eggColor1, eggColor2, new Item.Properties().m_41491_(eggGroup)));
    }

    default public <T extends Mob> EntityType<T> register(String name, EntityType.Builder<T> entityTypeBuilder, Supplier<AttributeSupplier.Builder> attribModifierSupplier, int eggColor1, int eggColor2, CreativeModeTab eggGroup) {
        EntityType entityType = entityTypeBuilder.m_20712_(name);
        this.register(name, entityType, attribModifierSupplier, eggColor1, eggColor2, eggGroup);
        return entityType;
    }

    public SoundEvent register(String var1, SoundEvent var2);
}

