/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.mobz.MathUtils;
import net.mobz.entity.ToadEntity;

public class ToadEntityModel
extends EntityModel<ToadEntity> {
    public static final Random random = new Random();
    private final float bodyScale;
    private final ModelPart body;
    private final ModelPart backlege;
    private final ModelPart backlegw;
    private final ModelPart eyeballw;
    private final ModelPart eyeballe;
    private final ModelPart lips;
    private final ModelPart lipBottom;
    private final ModelPart lipTop;
    private final ModelPart frontlegw;
    private final ModelPart frontlege;
    private float tongue_xRot;
    private float tongue_yRot;
    private float tongueDistance;
    private float targetTongueDistance;
    private float eyeHeight;
    public static final ModelLayerLocation modelResLoc = new ModelLayerLocation(new ResourceLocation("mobz", "toad_model"), "main");

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -2.0f, 8.0f, 8.0f, 8.0f).m_171514_(10, 24).m_171481_(1.0f, -10.0f, -1.0f, 2.0f, 2.0f, 3.0f).m_171514_(0, 24).m_171481_(-3.0f, -10.0f, -1.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-0.2727f));
        body.m_171599_("backlege", CubeListBuilder.m_171558_().m_171514_(8, 16).m_171481_(-2.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f).m_171514_(12, 16).m_171481_(-2.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)-3.0f, (float)5.0f));
        body.m_171599_("backlegw", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(0.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f).m_171514_(24, 16).m_171481_(0.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)4.0f, (float)-3.0f, (float)5.0f));
        body.m_171599_("eyeballw", CubeListBuilder.m_171558_().m_171514_(18, 28).m_171481_(0.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171419_((float)2.5f, (float)-9.5f, (float)0.5f));
        body.m_171599_("eyeballe", CubeListBuilder.m_171558_().m_171514_(24, 3).m_171481_(-1.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-2.5f, (float)-9.5f, (float)0.5f));
        PartDefinition lips = body.m_171599_("lips", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-2.0f));
        lips.m_171599_("lip_bottom", CubeListBuilder.m_171558_().m_171514_(20, 18).m_171481_(-3.0f, 1.0f, -1.0f, 6.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        lips.m_171599_("lip_top", CubeListBuilder.m_171558_().m_171514_(20, 16).m_171481_(-3.0f, 0.0f, -1.0f, 6.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontlegw = body.m_171599_("frontlegw", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-5.0f, (float)-1.0f));
        frontlegw.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(22, 22).m_171481_(0.0f, 0.684f, -1.3794f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition frontlege = body.m_171599_("frontlege", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-5.0f, (float)-1.0f));
        frontlege.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -6.0f, 0.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ToadEntityModel(ModelPart modelPart, float bodyScale) {
        this.bodyScale = bodyScale;
        this.body = modelPart.m_171324_("body");
        this.backlege = this.body.m_171324_("backlege");
        this.backlegw = this.body.m_171324_("backlegw");
        this.eyeballw = this.body.m_171324_("eyeballw");
        this.eyeballe = this.body.m_171324_("eyeballe");
        this.lips = this.body.m_171324_("lips");
        this.lipBottom = this.lips.m_171324_("lip_bottom");
        this.lipTop = this.lips.m_171324_("lip_top");
        this.frontlegw = this.body.m_171324_("frontlegw");
        this.frontlege = this.body.m_171324_("frontlege");
    }

    public void setupAnim(ToadEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        float legAmount = 1.4f;
        this.frontlege.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f + pi)) * 1.4f * limbDistance;
        this.backlege.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f)) * legAmount * limbDistance;
        this.frontlegw.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f)) * 1.4f * limbDistance;
        this.backlegw.f_104203_ = Mth.m_14089_((float)(limbAngle * 1.0f + pi)) * legAmount * limbDistance;
        if (!entity.m_20096_()) {
            this.backlegw.f_104203_ = 2.0f;
            this.backlege.f_104203_ = 2.0f;
        }
        entity.mouthDistance = entity.hasTongueEntity() ? MathUtils.approachValue(entity.mouthDistance, 1.0f, 0.5f) : MathUtils.approachValue(entity.mouthDistance, 0.0f, 0.1f);
        this.lipTop.f_104201_ = -entity.mouthDistance;
        this.lipBottom.f_104201_ = entity.mouthDistance;
        this.tongue_xRot = headPitch * 0.0175f;
        this.tongue_yRot = headYaw * 0.0175f;
        this.tongueDistance = entity.tongueDistance;
        this.targetTongueDistance = entity.targetTongueDistance;
        this.eyeHeight = entity.m_20192_();
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int overlay, float r, float g, float b, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, overlay, r, g, b, alpha);
        if (this.tongueDistance <= 0.01f) {
            return;
        }
        poseStack.m_85836_();
        this.body.m_104299_(poseStack);
        this.renderTongue(poseStack, vertexConsumer, packedLight, overlay, r, g, b, alpha);
        poseStack.m_85849_();
    }

    public void renderTongue(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        matrices.m_85836_();
        float mouthHeightRelative = 0.1875f;
        float mouthHorizontalOffsetRelative = 0.125f;
        float tongueDistance = this.targetTongueDistance;
        float mouthHeight = mouthHeightRelative * this.bodyScale;
        float mouthHorizontalOffset = mouthHorizontalOffsetRelative * this.bodyScale;
        float mouthVerticalOffset = this.eyeHeight - mouthHeight;
        float mouthEyeDistanceSqr = mouthVerticalOffset * mouthVerticalOffset + mouthHorizontalOffset * mouthHorizontalOffset;
        float mouthEyeDistance = Mth.m_14116_((float)mouthEyeDistanceSqr);
        float angleMouthEye = (float)Mth.m_14136_((double)mouthHorizontalOffset, (double)mouthVerticalOffset);
        float cosEM_ET = Mth.m_14031_((float)(angleMouthEye + this.tongue_xRot));
        float lenSqr = mouthEyeDistanceSqr + tongueDistance * tongueDistance - 2.0f * mouthEyeDistance * tongueDistance * cosEM_ET;
        float len = Mth.m_14116_((float)lenSqr);
        float cosME_MT = (mouthEyeDistanceSqr + lenSqr - tongueDistance * tongueDistance) / (2.0f * mouthEyeDistance * len);
        float xRot = (float)(Math.acos(cosME_MT) - 1.5707963705062866 - (double)angleMouthEye);
        len *= this.tongueDistance / this.targetTongueDistance;
        matrices.m_85837_(0.0, (double)(-mouthHeightRelative), (double)(-mouthHorizontalOffsetRelative));
        if (xRot != 0.0f) {
            matrices.m_85845_(Vector3f.f_122223_.m_122270_(xRot));
        }
        if (this.tongue_yRot != 0.0f) {
            matrices.m_85845_(Vector3f.f_122225_.m_122270_(this.tongue_yRot));
        }
        matrices.m_85841_(1.0f, 1.0f, len / this.bodyScale * 16.0f);
        ModelPart.Cube cuboid = new ModelPart.Cube(16, 0, -1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f);
        cuboid.m_171332_(matrices.m_85850_(), vertexConsumer, light, overlay, 1.0f, 0.0f, 0.0f, 0.0f);
        matrices.m_85849_();
    }
}

