/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;
import net.mobz.init.MobZWeapons;

public class Knight4Entity
extends TamableAnimal
implements NeutralMob {
    public static final Predicate<LivingEntity> FOLLOW_TAMED_PREDICATE = livingEntity -> {
        EntityType entityType = livingEntity.m_6095_();
        return entityType == EntityType.f_20520_ || entityType == EntityType.f_20517_ || entityType == EntityType.f_20452_;
    };

    public Knight4Entity(EntityType<? extends Knight4Entity> entityType, Level world) {
        super(entityType, world);
        this.m_7105_(false);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MobZWeapons.ArmoredSword));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, FOLLOW_TAMED_PREDICATE));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createKnight4EntityAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(MobZSounds.LEATHERWALKEVENT, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return MobZSounds.NOTHINGEVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12323_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        boolean bl = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (bl) {
            this.m_19970_((LivingEntity)this, target);
        }
        return bl;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || item == Items.f_42587_ && !this.m_21824_() && !this.m_21660_();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_5634_(item.m_41473_().m_38744_());
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41941_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41941_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41949_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41949_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41946_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41946_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41947_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41947_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41944_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41944_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41945_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41945_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41942_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41942_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41943_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41943_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41939_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41939_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41948_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41948_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41950_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41950_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_41940_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41940_));
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41726_(new ItemStack((ItemLike)Items.f_42740_))) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
                return InteractionResult.SUCCESS;
            }
        } else if (item == Items.f_42500_ && !this.m_21660_()) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (this.f_19796_.nextInt(3) == 0) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public Knight4Entity getBreedOffspring(ServerLevel world, AgeableMob passiveEntity) {
        Knight4Entity Knight4Entity2 = (Knight4Entity)MobZEntities.KNIGHT4ENTITY.m_20615_(this.f_19853_);
        UUID uUID = this.m_142504_();
        if (uUID != null) {
            Knight4Entity2.m_21816_(uUID);
            Knight4Entity2.m_7105_(true);
        }
        return Knight4Entity2;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof Knight4Entity) {
                Knight4Entity Knight4Entity2 = (Knight4Entity)target;
                return !Knight4Entity2.m_21824_() || Knight4Entity2.m_142480_() != owner;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42575_;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int ticks) {
    }

    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(UUID uuid) {
    }

    public void m_6825_() {
    }
}

