/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mobz.MobZ;
import net.mobz.entity.SpiSmall;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;

public class MageEntity
extends SpellcasterIllager {
    private Sheep wololoTarget;

    public MageEntity(EntityType<? extends MageEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createMageEntityAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, MobZ.configs.SpiderMageLife * MobZ.configs.LifeMultiplicatorMob).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22281_, MobZ.configs.SpiderMageAttack * MobZ.configs.DamageMultiplicatorMob).m_22268_(Attributes.f_22277_, 20.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SummonSpider());
        this.f_21345_.m_25352_(5, (Goal)new ConjureFangsGoal());
        this.f_21345_.m_25352_(6, (Goal)new WololoGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public boolean m_6914_(LevelReader view) {
        BlockPos blockunderentity = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
        BlockPos posentity = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
        return view.m_45784_((Entity)this) && !this.m_33067_() && !this.f_19853_.m_46855_(this.m_142469_()) && this.f_19853_.m_8055_(posentity).m_60734_().m_5568_() && this.f_19853_.m_8055_(blockunderentity).m_60643_((BlockGetter)view, blockunderentity, MobZEntities.MAGEENTITY) && MobZ.configs.SpiderMageSpawn;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public boolean m_7307_(Entity entity_1) {
        if (entity_1 == null) {
            return false;
        }
        if (entity_1 == this) {
            return true;
        }
        if (super.m_7307_(entity_1)) {
            return true;
        }
        return entity_1 instanceof SpiSmall;
    }

    protected SoundEvent m_7515_() {
        return MobZSounds.EVEIDLEEVENT;
    }

    protected SoundEvent m_5592_() {
        return MobZSounds.EVEDEATHEVENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource_1) {
        return MobZSounds.EVEHURTEVENT;
    }

    private void setWololoTarget(@Nullable Sheep sheep) {
        this.wololoTarget = sheep;
    }

    @Nullable
    private Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)MageEntity.this);
        }

        public void m_8037_() {
            if (MageEntity.this.m_5448_() != null) {
                MageEntity.this.m_21563_().m_24960_((Entity)MageEntity.this.m_5448_(), (float)MageEntity.this.m_8085_(), (float)MageEntity.this.m_8132_());
            } else if (MageEntity.this.getWololoTarget() != null) {
                MageEntity.this.m_21563_().m_24960_((Entity)MageEntity.this.getWololoTarget(), (float)MageEntity.this.m_8085_(), (float)MageEntity.this.m_8132_());
            }
        }
    }

    class SummonSpider
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions closeVexPredicate;

        private SummonSpider() {
            super((SpellcasterIllager)MageEntity.this);
            this.closeVexPredicate = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int i = MageEntity.this.f_19853_.m_45971_(SpiSmall.class, this.closeVexPredicate, (LivingEntity)MageEntity.this, MageEntity.this.m_142469_().m_82400_(16.0)).size();
            return MageEntity.this.f_19796_.nextInt(8) + 1 > i;
        }

        protected int m_8089_() {
            return 100;
        }

        protected int m_8067_() {
            return 340;
        }

        protected void m_8130_() {
            ServerLevel serverWorld = (ServerLevel)MageEntity.this.f_19853_;
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos = MageEntity.this.m_142538_().m_142082_(-2 + MageEntity.this.f_19796_.nextInt(5), 1, -2 + MageEntity.this.f_19796_.nextInt(5));
                SpiSmall vexEntity = (SpiSmall)MobZEntities.SPISMALL.m_20615_(MageEntity.this.f_19853_);
                vexEntity.m_20035_(blockPos, 0.0f, 0.0f);
                vexEntity.m_6518_((ServerLevelAccessor)serverWorld, MageEntity.this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                vexEntity.setLifeTicks(20 * (30 + MageEntity.this.f_19796_.nextInt(90)));
                MageEntity.this.f_19853_.m_7967_((Entity)vexEntity);
            }
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11868_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class ConjureFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private ConjureFangsGoal() {
            super((SpellcasterIllager)MageEntity.this);
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 100;
        }

        protected void m_8130_() {
            LivingEntity livingEntity = MageEntity.this.m_5448_();
            double d = Math.min(livingEntity.m_20186_(), MageEntity.this.m_20186_());
            double e = Math.max(livingEntity.m_20186_(), MageEntity.this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingEntity.m_20189_() - MageEntity.this.m_20189_()), (double)(livingEntity.m_20185_() - MageEntity.this.m_20185_()));
            if (MageEntity.this.m_20280_((Entity)livingEntity) < 9.0) {
                float h;
                int j;
                for (j = 0; j < 5; ++j) {
                    h = f + (float)j * (float)Math.PI * 0.4f;
                    this.conjureFangs(MageEntity.this.m_20185_() + (double)Mth.m_14089_((float)h) * 1.5, MageEntity.this.m_20189_() + (double)Mth.m_14031_((float)h) * 1.5, d, e, h, 0);
                }
                for (j = 0; j < 8; ++j) {
                    h = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(MageEntity.this.m_20185_() + (double)Mth.m_14089_((float)h) * 2.5, MageEntity.this.m_20189_() + (double)Mth.m_14031_((float)h) * 2.5, d, e, h, 3);
                }
            } else {
                for (int j = 0; j < 16; ++j) {
                    double l = 1.25 * (double)(j + 1);
                    int m = 1 * j;
                    this.conjureFangs(MageEntity.this.m_20185_() + (double)Mth.m_14089_((float)f) * l, MageEntity.this.m_20189_() + (double)Mth.m_14031_((float)f) * l, d, e, f, m);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float f, int warmup) {
            BlockPos blockPos = new BlockPos(x, y, z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2;
                BlockState blockState;
                if (!(blockState = MageEntity.this.f_19853_.m_8055_(blockPos2 = blockPos.m_7495_())).m_60783_((BlockGetter)MageEntity.this.f_19853_, blockPos2, Direction.UP)) continue;
                if (!MageEntity.this.f_19853_.m_46859_(blockPos) && !(voxelShape = (blockState2 = MageEntity.this.f_19853_.m_8055_(blockPos)).m_60812_((BlockGetter)MageEntity.this.f_19853_, blockPos)).m_83281_()) {
                    d = voxelShape.m_83297_(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (bl) {
                MageEntity.this.f_19853_.m_7967_((Entity)new EvokerFangs(MageEntity.this.f_19853_, x, (double)blockPos.m_123342_() + d, z, f, warmup, (LivingEntity)MageEntity.this));
            }
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11867_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class WololoGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions purpleSheepPredicate;

        public WololoGoal() {
            super((SpellcasterIllager)MageEntity.this);
            this.purpleSheepPredicate = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(sheepTarget -> ((Sheep)sheepTarget).m_29874_() == DyeColor.BLUE);
        }

        public boolean m_8036_() {
            if (MageEntity.this.m_5448_() != null) {
                return false;
            }
            if (MageEntity.this.m_33736_()) {
                return false;
            }
            if (MageEntity.this.f_19797_ < this.f_33775_) {
                return false;
            }
            if (!MageEntity.this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                return false;
            }
            List list = MageEntity.this.f_19853_.m_45971_(Sheep.class, this.purpleSheepPredicate, (LivingEntity)MageEntity.this, MageEntity.this.m_142469_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            MageEntity.this.setWololoTarget((Sheep)list.get(MageEntity.this.f_19796_.nextInt(list.size())));
            return true;
        }

        public boolean m_8045_() {
            return MageEntity.this.getWololoTarget() != null && this.f_33774_ > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            MageEntity.this.setWololoTarget(null);
        }

        protected void m_8130_() {
            Sheep sheepEntity = MageEntity.this.getWololoTarget();
            if (sheepEntity != null && sheepEntity.m_6084_()) {
                sheepEntity.m_29855_(DyeColor.RED);
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11869_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

