/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.mobz.entity.ToadEntity;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZItems;

public class TadpoleEntity
extends AbstractFish {
    private int babyTime = -6000;

    public TadpoleEntity(EntityType<? extends TadpoleEntity> entityType, Level world) {
        super(entityType, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            ++this.babyTime;
            if (!this.m_6162_()) {
                ToadEntity toad = (ToadEntity)MobZEntities.TOAD.m_20615_(this.f_19853_);
                toad.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_20883_, this.m_146909_());
                toad.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 0));
                ((ServerLevel)this.f_19853_).m_47205_((Entity)toad);
                this.m_146870_();
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_41619_() && itemStack.m_150922_(ToadEntity.getToadFoodTag())) {
            if (this.m_6162_()) {
                itemStack.m_41774_(1);
                this.growUp(Math.abs(this.babyTime / 20));
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void growUp(int age) {
        this.babyTime += age;
    }

    public void m_6863_(boolean baby) {
        this.babyTime = baby ? -24000 : 0;
    }

    public boolean m_6162_() {
        return this.babyTime < 0;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("BabyTime", this.babyTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("BabyTime")) {
            this.babyTime = tag.m_128451_("BabyTime");
        }
    }

    public ItemStack m_142563_() {
        return new ItemStack(MobZItems.TADPOLE_BUCKET);
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    public static AttributeSupplier.Builder createEntityAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }
}

