/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.mobz.MathUtils;
import net.mobz.MobZ;
import net.mobz.entity.TadpoleEntity;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;

public class ToadEntity
extends Animal {
    private static Set<Entity> targetedEntities = new HashSet<Entity>();
    private static final UUID JUMP_SPEED_BOOST = UUID.fromString("0fa7caca-4f09-11eb-ae93-0242ac130002");
    private static final AttributeModifier JUMP_SPEED_BOOST_MOD = new AttributeModifier(JUMP_SPEED_BOOST, "Jump Speed Boost", (double)0.6f, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> TONGUE_ENTITY = SynchedEntityData.m_135353_(ToadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean onGroundPrev;
    private int ticksUntilJump;
    public float tongueDistance;
    public float targetTongueDistance;
    public float mouthDistance = 0.0f;
    public int eatCooldown = 0;
    public boolean hasBaby;
    private final TargetingConditions predicate = TargetingConditions.m_148353_().m_26888_(e -> e.m_20270_((Entity)e) < 10.0f);

    public ToadEntity(EntityType<? extends ToadEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TONGUE_ENTITY, (Object)-1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTongueTarget(this));
        this.f_21345_.m_25352_(0, (Goal)new MakeTadpoleGoal(this, 1.0, 10));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43911_(ToadEntity.getToadFoodTag()), false));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTongueEntity(LivingEntity e) {
        this.f_19804_.m_135381_(TONGUE_ENTITY, (Object)e.m_142049_());
        if (this.f_19853_.m_5776_()) return;
        this.m_5496_(MobZSounds.TOAD_MOUTH, 1.0f, 1.0f + (float)this.f_19796_.nextGaussian() / 5.0f);
        Class<ToadEntity> clazz = ToadEntity.class;
        synchronized (ToadEntity.class) {
            targetedEntities.add((Entity)e);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean hasTongueEntity() {
        return (Integer)this.f_19804_.m_135370_(TONGUE_ENTITY) != -1;
    }

    @Nullable
    public Entity getTongueEntity() {
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(TONGUE_ENTITY)).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void clearTongueEntity() {
        Entity e;
        if (!this.f_19853_.m_5776_() && (e = this.getTongueEntity()) != null) {
            Class<ToadEntity> clazz = ToadEntity.class;
            // MONITORENTER : net.mobz.entity.ToadEntity.class
            targetedEntities.remove(e);
            // MONITOREXIT : clazz
        }
        this.f_19804_.m_135381_(TONGUE_ENTITY, (Object)-1);
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        if (world.m_8055_(pos).m_60713_(Blocks.f_50196_)) {
            return 100.0f;
        }
        return super.m_5610_(pos, world);
    }

    private void dragVictim(LivingEntity victim) {
        if (this.m_21224_() || this.m_146910_() || !this.m_142582_((Entity)victim) || victim.m_146910_() || this.m_20270_((Entity)victim) > (float)(this.getSpotRange() * 2)) {
            this.clearTongueEntity();
            return;
        }
        if (this.isTongueReady()) {
            if (victim.m_142469_().m_82381_(this.m_142469_())) {
                this.attackVictim(victim);
            } else {
                double speed = this.getTongueSpeed2();
                double xx = MathUtils.approachValue(victim.m_20182_().f_82479_, this.m_20185_(), speed);
                double yy = MathUtils.approachValue(victim.m_20182_().f_82480_, this.m_20186_() + (double)0.2f, speed / 2.0);
                double zz = MathUtils.approachValue(victim.m_20182_().f_82481_, this.m_20189_(), speed);
                victim.m_20248_(xx, yy, zz);
                victim.m_20334_(0.0, 0.0, 0.0);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasBaby && this.m_146764_() == 0) {
            this.hasBaby = false;
        }
        if (this.hasTongueEntity()) {
            Entity e = this.getTongueEntity();
            if (e != null && !e.m_20159_()) {
                Vec3 victimCenter = e.m_142469_().m_82399_();
                this.m_21563_().m_24950_(victimCenter.f_82479_, e.m_20186_(), victimCenter.f_82481_, 100.0f, 100.0f);
                this.f_20883_ = this.getTargetYaw();
                this.f_20885_ = this.getTargetYaw();
                this.m_146926_(this.getTargetPitch());
                float speed = this.getTongueSpeed();
                this.targetTongueDistance = this.m_20270_(e) - (float)(e.m_142469_().f_82291_ - e.m_142469_().f_82288_);
                this.targetTongueDistance = (float)this.m_146892_().m_82554_(victimCenter);
                if (this.tongueDistance > this.targetTongueDistance) {
                    speed *= 2.0f;
                }
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, this.targetTongueDistance, speed);
                if ((double)Math.abs(this.tongueDistance - this.targetTongueDistance) < 0.001) {
                    this.dragVictim((LivingEntity)e);
                }
            } else {
                this.targetTongueDistance = 0.0f;
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
            }
        } else {
            this.targetTongueDistance = 0.0f;
            this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
        }
    }

    public boolean isTongueReady() {
        float yaw = Math.abs((this.f_20883_ + 1.0f) % 360.0f - this.getTargetYaw());
        boolean dis = Math.abs(this.tongueDistance - this.targetTongueDistance) < 5.0f;
        return dis && (yaw < 4.0f || yaw >= 360.0f);
    }

    public float getTargetYaw() {
        double xx = this.f_21365_.m_24969_() - this.m_20185_();
        double zz = this.f_21365_.m_24971_() - this.m_20189_();
        return (float)(Mth.m_14136_((double)zz, (double)xx) * 57.2957763671875) - 90.0f;
    }

    public float getTargetPitch() {
        double xx = this.f_21365_.m_24969_() - this.m_20185_();
        double yy = this.f_21365_.m_24970_() - this.m_20188_();
        double zz = this.f_21365_.m_24971_() - this.m_20189_();
        double sqrt = Math.sqrt(xx * xx + zz * zz);
        return (float)(-(Mth.m_14136_((double)yy, (double)sqrt) * 57.2957763671875));
    }

    public boolean canUseTongue() {
        return !this.m_20159_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150922_(ToadEntity.getToadFoodTag());
    }

    public void m_8024_() {
        --this.eatCooldown;
        if (this.eatCooldown <= 0 && !this.hasTongueEntity()) {
            double spotRange = this.getSpotRange();
            List targets = this.f_19853_.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), this.m_142469_().m_82377_(spotRange, spotRange, spotRange), this::isToadTarget);
            LivingEntity closest = this.f_19853_.m_45982_(targets, this.predicate, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!this.canUseTongue() || closest == null || closest.m_20159_() || targets.isEmpty()) {
                this.clearTongueEntity();
            } else {
                this.eatCooldown = 100;
                this.setTongueEntity(closest);
            }
        } else {
            Entity e = this.getTongueEntity();
            if (!this.canUseTongue() || e == null || !e.m_6084_()) {
                this.clearTongueEntity();
            }
        }
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.ticksUntilJump <= 0 && this.f_21342_.m_24995_()) {
            this.ticksUntilJump = this.f_19796_.nextInt(80) + 20;
            this.m_6135_();
            AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
            entityAttributeInstance.m_22120_(JUMP_SPEED_BOOST);
            entityAttributeInstance.m_22118_(JUMP_SPEED_BOOST_MOD);
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
        if (this.f_19861_ && !this.onGroundPrev) {
            this.m_21051_(Attributes.f_22279_).m_22130_(JUMP_SPEED_BOOST_MOD);
        }
        this.onGroundPrev = this.f_19861_;
    }

    protected SoundEvent getJumpSound() {
        return MobZSounds.TOAD_JUMP;
    }

    public static AttributeSupplier.Builder createEntityAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("HasBaby", this.hasBaby);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.hasBaby = tag.m_128471_("HasBaby");
    }

    public void setHasBaby(boolean hasBaby) {
        this.hasBaby = hasBaby;
    }

    public void m_27563_(ServerLevel serverWorld, Animal other) {
        ServerPlayer player = this.m_27592_();
        if (player == null && other.m_27592_() != null) {
            player = other.m_27592_();
        }
        if (player != null) {
            player.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(player, (Animal)this, other, null);
        }
        this.setHasBaby(true);
        this.m_146762_(6000);
        other.m_146762_(6000);
        this.m_27594_();
        other.m_27594_();
        serverWorld.m_7605_((Entity)this, (byte)18);
        if (serverWorld.m_46469_().m_46207_(GameRules.f_46135_)) {
            serverWorld.m_7967_((Entity)new ExperienceOrb((Level)serverWorld, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
        }
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return MobZSounds.TOAD_CROAK;
    }

    protected SoundEvent m_5592_() {
        return MobZSounds.TOAD_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return MobZSounds.TOAD_HURT;
    }

    public float m_6100_() {
        return super.m_6100_() + (float)this.f_19796_.nextGaussian() / 8.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isToadTarget(Entity entity) {
        if (!this.canToadTarget((LivingEntity)entity) || !this.m_142582_(entity)) {
            return false;
        }
        Class<ToadEntity> clazz = ToadEntity.class;
        synchronized (ToadEntity.class) {
            double FOV;
            double diff;
            double dz;
            double dx;
            double dir;
            if (targetedEntities.contains(entity)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            double headingAngle = this.m_6080_() + 90.0f;
            if (headingAngle > 360.0) {
                headingAngle -= 360.0;
            }
            if (headingAngle < 0.0) {
                headingAngle += 360.0;
            }
            if ((dir = 90.0 - Mth.m_14136_((double)(dx = entity.m_20185_() - this.m_20185_()), (double)(dz = entity.m_20189_() - this.m_20189_())) / 3.1415927410125732 * 180.0) > 360.0) {
                dir -= 360.0;
            }
            if (dir < 0.0) {
                dir += 360.0;
            }
            return (diff = dir - headingAngle) < (FOV = 90.0) / 2.0 && diff > -FOV / 2.0;
        }
    }

    public static Tag<Item> getToadFoodTag() {
        return ItemTags.m_13193_().m_7689_(MobZ.TOAD_FOOD);
    }

    public boolean canToadTarget(LivingEntity entity) {
        return EntityTypeTags.m_13126_().m_7689_(MobZ.TOAD_TARGET).m_8110_((Object)entity.m_6095_());
    }

    public void attackVictim(LivingEntity victim) {
        if (victim instanceof Player) {
            victim.m_6469_(DamageSource.m_19340_((Entity)this, null), 1.0f);
        } else {
            victim.m_6469_(DamageSource.m_19340_((Entity)this, null), Float.MAX_VALUE);
        }
    }

    public int getSpotRange() {
        return 5;
    }

    protected float getTongueSpeed() {
        return 0.8f;
    }

    protected float getTongueSpeed2() {
        return 0.4f;
    }

    private class LookAtTongueTarget
    extends Goal {
        private final ToadEntity toad;

        public LookAtTongueTarget(ToadEntity entity) {
            this.toad = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.toad.hasTongueEntity();
        }

        public boolean m_8045_() {
            return this.toad.hasTongueEntity();
        }
    }

    public class MakeTadpoleGoal
    extends MoveToBlockGoal {
        private final ToadEntity toad;

        public MakeTadpoleGoal(ToadEntity toad, double speed, int range) {
            super((PathfinderMob)toad, speed, range, 5);
            this.toad = toad;
        }

        public boolean m_8036_() {
            return this.toad.hasBaby && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.toad.hasBaby;
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockPos = this.f_25598_.m_142538_();
            if (this.m_6669_().m_123306_((Position)this.toad.m_20182_(), 2.0)) {
                ToadEntity.this.m_21573_().m_26519_((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + 0.5f), 1.0);
            }
            if (this.toad.m_20069_()) {
                ServerLevel world = (ServerLevel)this.toad.f_19853_;
                this.toad.setHasBaby(false);
                TadpoleEntity tadpole = (TadpoleEntity)MobZEntities.TADPOLE.m_20615_((Level)world);
                if (tadpole != null) {
                    world.m_5594_(null, blockPos, MobZSounds.TOAD_HAVE_BABY, SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.nextFloat() * 0.2f);
                    tadpole.m_6863_(true);
                    tadpole.m_7678_(this.toad.m_20185_(), this.toad.m_20186_(), this.toad.m_20189_(), 0.0f, 0.0f);
                    world.m_47205_((Entity)tadpole);
                }
            }
        }

        public double m_8052_() {
            return 0.0;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            FluidState state = world.m_6425_(pos);
            return state.m_76170_() && state.m_76153_((Tag)FluidTags.f_13131_) && world.m_8055_(pos.m_7494_()).m_60795_();
        }
    }
}

