/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.forge;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.mobz.ILootTableAdder;
import net.mobz.MobZ;
import net.mobz.forge.ClientRegistrationHandler;
import net.mobz.forge.ForgeMobSpawnAdder;
import net.mobz.forge.ForgeRegistryWrapper;
import net.mobz.forge.datagen.SpawnEggItemModelDataProvider;
import net.mobz.init.LootTableModifier;
import net.mobz.init.MobSpawnRestrictions;
import net.mobz.init.MobSpawns;
import net.mobz.portable.StaticAPIWrapper;

@Mod(value="mobz")
public class ForgeEntry {
    public static ForgeEntry instance;
    private static ForgeMobSpawnAdder mobSpawns;

    public ForgeEntry() {
        if (instance != null) {
            throw new RuntimeException("Duplicated Class Instantiation: net.mobz.forge.MobZ");
        }
        instance = this;
        MobZ.initConfig();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientRegistrationHandler::registerConfigGui);
        MobZ.invokeStaticFields();
        MobSpawnRestrictions.applyAll(SpawnPlacements::m_21754_);
        MobSpawns.addMobSpawns(mobSpawns);
    }

    static {
        mobSpawns = new ForgeMobSpawnAdder();
    }

    @Mod.EventBusSubscriber(modid="mobz", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class ForgeEventBusHandler {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
            if (event.getPhase() == EventPriority.HIGH) {
                mobSpawns.addMobSpawns(event.getCategory(), event.getSpawns());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onLootTableLoadEvent(LootTableLoadEvent event) {
            ILootTableAdder lootTableAdder = (lootTableIDs, range, entryBuilder) -> {
                for (ResourceLocation lootTableID : lootTableIDs) {
                    if (!event.getName().equals((Object)lootTableID)) continue;
                    event.getTable().addPool(LootPool.m_79043_().m_165133_(range).m_79076_((LootPoolEntryContainer.Builder)entryBuilder).m_79082_());
                }
            };
            LootTableModifier.loadAll(lootTableAdder);
        }
    }

    @Mod.EventBusSubscriber(modid="mobz", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ModEventBusHandler {
        @SubscribeEvent
        public static void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
            ((ForgeRegistryWrapper)StaticAPIWrapper.instance).applyGlobalEntityAttrib((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void onDataGeneratorInvoked(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            ExistingFileHelper exfh = event.getExistingFileHelper();
            if (event.includeClient()) {
                generator.m_123914_((DataProvider)new SpawnEggItemModelDataProvider(generator, exfh));
            }
        }
    }
}

