/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.forge;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.mobz.IRegistryWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeRegistryWrapper
implements IRegistryWrapper {
    private final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mobz");
    private final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mobz");
    private final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"mobz");
    private final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"mobz");
    private Set<Pair<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>> attribSuppliers = new HashSet<Pair<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>>();

    public ForgeRegistryWrapper() {
        this.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.ENTITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public void applyGlobalEntityAttrib(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> regFunc) {
        this.attribSuppliers.forEach(pair -> regFunc.accept((EntityType)pair.getLeft(), ((AttributeSupplier.Builder)((Supplier)pair.getRight()).get()).m_22265_()));
        this.attribSuppliers.clear();
        this.attribSuppliers = null;
    }

    @Override
    public CreativeModeTab tab(ResourceLocation resLoc, final Supplier<ItemStack> iconSupplier) {
        return new CreativeModeTab(resLoc.m_135827_() + "." + resLoc.m_135815_()){

            public ItemStack m_6976_() {
                return (ItemStack)iconSupplier.get();
            }
        };
    }

    @Override
    public Item register(String name, Item item) {
        this.ITEMS.register(name, () -> item);
        return item;
    }

    @Override
    public BlockItem register(String name, BlockItem blockItem) {
        this.ITEMS.register(name, () -> blockItem);
        this.BLOCKS.register(name, () -> blockItem.m_40614_());
        return blockItem;
    }

    @Override
    public <T extends Entity> EntityType<T> register(String name, EntityType<T> entityType) {
        this.ENTITY_TYPES.register(name, () -> entityType);
        return entityType;
    }

    @Override
    public <T extends LivingEntity> EntityType<T> entityAttribModifier(EntityType<T> entityType, Supplier<AttributeSupplier.Builder> attribModifierSupplier) {
        this.attribSuppliers.add((Pair<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>)Pair.of(entityType, attribModifierSupplier));
        return entityType;
    }

    @Override
    public SoundEvent register(String name, SoundEvent sound) {
        this.SOUNDS.register(name, () -> sound);
        return sound;
    }
}

