/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.mobz.MobZ;
import net.mobz.block.TotemBase;
import net.mobz.init.MobZBlocks;

public class SacrificeKnife
extends Item {
    public SacrificeKnife(Item.Properties settings) {
        super(settings);
    }

    public static int getBloodCounter(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41698_("mobz");
        return SacrificeKnife.getIntOrDef(nbt, "bloodCounter", 0);
    }

    public static int getDryingNumber(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41698_("mobz");
        return SacrificeKnife.getIntOrDef(nbt, "dryingNumber", 0);
    }

    private static void setParam(ItemStack itemStack, int bloodCounter, int dryingNumber) {
        CompoundTag nbt = itemStack.m_41698_("mobz");
        nbt.m_128405_("bloodCounter", bloodCounter);
        nbt.m_128405_("dryingNumber", dryingNumber);
    }

    public static int getIntOrDef(CompoundTag nbt, String key, int defaultVal) {
        return nbt.m_128441_(key) ? nbt.m_128451_(key) : defaultVal;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("item.mobz.sacrificeknife.tooltip"));
        tooltip.add((Component)new TranslatableComponent("item.mobz.sacrificeknife.tooltip2"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        int bloodCounter = SacrificeKnife.getBloodCounter(itemStack);
        int dryingNumber = SacrificeKnife.getDryingNumber(itemStack);
        if (user.m_21223_() > 2.0f) {
            user.m_6469_(DamageSource.f_19319_, 2.0f);
            if (dryingNumber < 4) {
                ++dryingNumber;
            }
            if (bloodCounter < 5000) {
                bloodCounter += 200;
            }
            SacrificeKnife.setParam(itemStack, bloodCounter, dryingNumber);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        int bloodCounter = SacrificeKnife.getBloodCounter(stack);
        int dryingNumber = SacrificeKnife.getDryingNumber(stack);
        if (bloodCounter > 0) {
            --bloodCounter;
        }
        if (bloodCounter == 0) {
            dryingNumber = 0;
        }
        SacrificeKnife.setParam(stack, bloodCounter, dryingNumber);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = world.m_8055_(pos);
        BlockState stateUp = world.m_8055_(pos.m_7494_());
        BlockState stateDown = world.m_8055_(pos.m_7495_());
        if (state.m_60734_() == MobZBlocks.TOTEM_MIDDLE) {
            if (stateUp.m_60734_() == MobZBlocks.TOTEM_TOP && stateDown.m_60734_() == MobZBlocks.TOTEM_BASE) {
                if (MobZ.configs.PillagerBossSpawn) {
                    ItemStack itemStack = context.m_43722_();
                    int bloodCounter = SacrificeKnife.getBloodCounter(itemStack);
                    if (!((Boolean)stateDown.m_61143_((Property)TotemBase.ENABLED)).booleanValue()) {
                        if (bloodCounter > 4000) {
                            world.m_5594_(player, pos, SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 1.0f);
                            MobZBlocks.TOTEM_BASE.trigger(world, pos.m_7495_());
                            SacrificeKnife.setParam(itemStack, 0, 0);
                            return InteractionResult.SUCCESS;
                        }
                        player.m_5661_((Component)new TranslatableComponent("text.mobz.sacrificeknifeblood"), true);
                        return InteractionResult.PASS;
                    }
                    return InteractionResult.PASS;
                }
                player.m_5661_((Component)new TranslatableComponent("text.mobz.pillagerspawnable"), true);
                return InteractionResult.PASS;
            }
            player.m_5661_((Component)new TranslatableComponent("text.mobz.pillagermissing"), true);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

