/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import io.github.how_bout_no.outvoted.config.OutvotedConfig;
import io.github.how_bout_no.outvoted.config.OutvotedConfigClient;
import io.github.how_bout_no.outvoted.config.OutvotedConfigCommon;
import io.github.how_bout_no.outvoted.entity.BarnacleEntity;
import io.github.how_bout_no.outvoted.entity.CopperGolemEntity;
import io.github.how_bout_no.outvoted.entity.GlareEntity;
import io.github.how_bout_no.outvoted.entity.GluttonEntity;
import io.github.how_bout_no.outvoted.entity.WildfireEntity;
import io.github.how_bout_no.outvoted.forge.OutvotedImpl;
import io.github.how_bout_no.outvoted.init.ModBlocks;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import io.github.how_bout_no.outvoted.init.ModItems;
import io.github.how_bout_no.outvoted.init.ModLootConditionTypes;
import io.github.how_bout_no.outvoted.init.ModRecipes;
import io.github.how_bout_no.outvoted.init.ModSounds;
import io.github.how_bout_no.outvoted.init.ModTags;
import io.github.how_bout_no.outvoted.util.EventRegister;
import io.github.how_bout_no.outvoted.util.compat.PatchouliCompat;
import io.github.how_bout_no.outvoted.world.gen.WorldGen;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.example.GeckoLibMod;
import software.bernie.geckolib3.GeckoLib;

public class Outvoted {
    public static final String MOD_ID = "outvoted";
    public static OutvotedConfig config;
    public static OutvotedConfigCommon commonConfig;
    public static OutvotedConfigClient clientConfig;
    public static CreativeModeTab TAB_BLOCKS;
    public static CreativeModeTab TAB_DECO;
    public static CreativeModeTab TAB_COMBAT;
    public static CreativeModeTab TAB_REDSTONE;
    public static CreativeModeTab TAB_MISC;
    public static CreativeModeTab[] TABS;

    public static void init() {
        AutoConfig.register(OutvotedConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        config = (OutvotedConfig)AutoConfig.getConfigHolder(OutvotedConfig.class).getConfig();
        clientConfig = Outvoted.config.client;
        commonConfig = Outvoted.config.common;
        GeckoLib.initialize();
        GeckoLibMod.DISABLE_IN_DEV = true;
        ModBlocks.BLOCKS.register();
        ModBlocks.BLOCK_ITEMS.register();
        ModEntityTypes.ENTITY_TYPES.register();
        ModItems.ITEMS.register();
        ModLootConditionTypes.register();
        ModRecipes.RECIPES.register();
        ModSounds.SOUNDS.register();
        ModTags.init();
        EventRegister.init();
        WorldGen.addSpawnEntries();
        EntityAttributeRegistry.register(() -> ModEntityTypes.WILDFIRE.get(), WildfireEntity::setCustomAttributes);
        EntityAttributeRegistry.register(() -> ModEntityTypes.GLUTTON.get(), GluttonEntity::setCustomAttributes);
        EntityAttributeRegistry.register(() -> ModEntityTypes.BARNACLE.get(), BarnacleEntity::setCustomAttributes);
        EntityAttributeRegistry.register(() -> ModEntityTypes.GLARE.get(), GlareEntity::setCustomAttributes);
        EntityAttributeRegistry.register(() -> ModEntityTypes.COPPER_GOLEM.get(), CopperGolemEntity::setCustomAttributes);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        if (Outvoted.clientConfig.creativeTab) {
            CreativeModeTab TAB;
            TAB_BLOCKS = TAB = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation(MOD_ID, "tab"), () -> new ItemStack((ItemLike)ModItems.WILDFIRE_HELMET.get()));
            TAB_DECO = TAB;
            TAB_COMBAT = TAB;
            TAB_MISC = TAB;
            TAB_REDSTONE = TAB;
        }
        if (Platform.isModLoaded((String)"patchouli")) {
            PatchouliCompat.updateFlag();
        }
        AutoConfig.getConfigHolder(OutvotedConfig.class).registerSaveListener((manager, data) -> {
            if (Platform.isModLoaded((String)"patchouli")) {
                PatchouliCompat.updateFlag();
            }
            return InteractionResult.SUCCESS;
        });
        AutoConfig.getConfigHolder(OutvotedConfig.class).registerLoadListener((manager, newData) -> {
            if (Platform.isModLoaded((String)"patchouli")) {
                PatchouliCompat.updateFlag();
            }
            return InteractionResult.SUCCESS;
        });
        Outvoted.registerModels();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModels() {
        OutvotedImpl.registerModels();
    }

    static {
        TAB_BLOCKS = CreativeModeTab.f_40749_;
        TAB_DECO = CreativeModeTab.f_40750_;
        TAB_COMBAT = CreativeModeTab.f_40757_;
        TAB_REDSTONE = CreativeModeTab.f_40751_;
        TAB_MISC = CreativeModeTab.f_40753_;
        TABS = new CreativeModeTab[]{TAB_BLOCKS, TAB_COMBAT, TAB_DECO, TAB_MISC, TAB_REDSTONE};
    }
}

