/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.github.how_bout_no.outvoted.block.BaseCopperButtonBlock;
import io.github.how_bout_no.outvoted.init.ModBlocks;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;

public interface IOxidizable
extends WeatheringCopper {
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().putAll((Map)WeatheringCopper.f_154886_.get()).put(ModBlocks.COPPER_BUTTON.get(), ModBlocks.EXPOSED_COPPER_BUTTON.get()).put(ModBlocks.EXPOSED_COPPER_BUTTON.get(), ModBlocks.WEATHERED_COPPER_BUTTON.get()).put(ModBlocks.WEATHERED_COPPER_BUTTON.get(), ModBlocks.OXIDIZED_COPPER_BUTTON.get()).build());
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_DECREASES = Suppliers.memoize(() -> OXIDATION_LEVEL_INCREASES.get().inverse());

    public static Optional<Block> getDecreasedOxidationBlock(Block block) {
        return Optional.ofNullable((Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Block getUnaffectedOxidationBlock(Block block) {
        Block block2 = block;
        Block block3 = (Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block3);
        }
        return block2;
    }

    public static Optional<BlockState> getDecreasedOxidationState(BlockState state) {
        return IOxidizable.getDecreasedOxidationBlock(state.m_60734_()).map(block -> ((BaseCopperButtonBlock)block).getStateWithPropertiesNoPower(state));
    }

    public static Optional<Block> getIncreasedOxidationBlock(Block block) {
        return Optional.ofNullable((Block)OXIDATION_LEVEL_INCREASES.get().get((Object)block));
    }

    public static BlockState getUnaffectedOxidationState(BlockState state) {
        return ((BaseCopperButtonBlock)IOxidizable.getUnaffectedOxidationBlock(state.m_60734_())).getStateWithPropertiesNoPower(state);
    }

    default public Optional<BlockState> m_142123_(BlockState state) {
        return IOxidizable.getIncreasedOxidationBlock(state.m_60734_()).map(block -> ((BaseCopperButtonBlock)block).getStateWithPropertiesNoPower(state));
    }

    default public float m_142377_() {
        return this.m_142297_() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }
}

