/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.client.model;

import io.github.how_bout_no.outvoted.entity.CopperGolemEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class CopperGolemModel
extends AnimatedGeoModel<CopperGolemEntity> {
    public ResourceLocation getAnimationFileLocation(CopperGolemEntity entity) {
        return new ResourceLocation("outvoted", "animations/copper_golem.animation.json");
    }

    public ResourceLocation getModelLocation(CopperGolemEntity entity) {
        return new ResourceLocation("outvoted", "geo/copper_golem.geo.json");
    }

    public ResourceLocation getTextureLocation(CopperGolemEntity entity) {
        return new ResourceLocation("outvoted", "textures/entity/copper_golem/copper_golem.png");
    }

    public void setLivingAnimations(CopperGolemEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getBone("head");
        IBone rightArm = this.getBone("rightarm");
        IBone leftArm = this.getBone("leftarm");
        IBone rightLeg = this.getBone("rightleg");
        IBone leftLeg = this.getBone("leftleg");
        if (entity.getOxidizationLevel() < 3) {
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            float limbSwing = entity.f_20925_;
            float limbSwingAmount = entity.f_20924_;
            float oxidizeMult = entity.getOxidizationMultiplier();
            if (oxidizeMult < 1.0f && oxidizeMult > 0.0f) {
                oxidizeMult += 0.25f;
            }
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * 0.009519978f);
            rightArm.setRotationX(Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult)) * 2.0f * limbSwingAmount);
            leftArm.setRotationX(Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult + (float)Math.PI)) * 2.0f * limbSwingAmount);
            rightLeg.setRotationX(Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult + (float)Math.PI)) * 2.0f * limbSwingAmount);
            leftLeg.setRotationX(Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult)) * 2.0f * limbSwingAmount);
        } else {
            float[] rot = entity.getRotations();
            head.setRotationX(rot[0] * ((float)(-Math.PI) / 180));
            head.setRotationY(rot[1] * -0.009519978f);
            rightArm.setRotationX(rot[2]);
            leftArm.setRotationX(rot[3]);
            rightLeg.setRotationX(rot[4]);
            leftLeg.setRotationX(rot[5]);
        }
    }
}

