/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.client.model;

import io.github.how_bout_no.outvoted.entity.GluttonEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class GluttonModel
extends AnimatedGeoModel<GluttonEntity> {
    public ResourceLocation getAnimationFileLocation(GluttonEntity entity) {
        return new ResourceLocation("outvoted", "animations/glutton.animation.json");
    }

    public ResourceLocation getModelLocation(GluttonEntity entity) {
        return new ResourceLocation("outvoted", "geo/glutton.geo.json");
    }

    public ResourceLocation getTextureLocation(GluttonEntity entity) {
        return new ResourceLocation("outvoted", "textures/entity/glutton/glutton.png");
    }

    public void setLivingAnimations(GluttonEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getBone("head");
        IBone legBR = this.getBone("LegBR");
        IBone legBL = this.getBone("LegBL");
        IBone legFR = this.getBone("LegFR");
        IBone legFL = this.getBone("LegFL");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * 0.009519978f);
        head.setRotationY(extraData.netHeadYaw * 0.009519978f);
        float limbSwing = entity.f_20925_;
        float limbSwingAmount = entity.f_20924_;
        legBR.setRotationX(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        legBL.setRotationX(Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
        legFR.setRotationX(Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
        legFL.setRotationX(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
    }
}

