/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.client.model.WildfireModel;
import io.github.how_bout_no.outvoted.entity.WildfireEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class WildfireRenderer
extends GeoEntityRenderer<WildfireEntity> {
    private static final ResourceLocation DEFAULT = new ResourceLocation("outvoted", "textures/entity/wildfire/wildfire.png");
    private static final ResourceLocation SOUL = new ResourceLocation("outvoted", "textures/entity/wildfire/wildfire_soul.png");

    public WildfireRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (AnimatedGeoModel)new WildfireModel());
    }

    public RenderType getRenderType(WildfireEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110458_((ResourceLocation)this.getTexture(animatable));
    }

    protected int getBlockLight(WildfireEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public ResourceLocation getTexture(WildfireEntity entity) {
        if (entity.getVariant() == 0 || !Outvoted.clientConfig.wildfireVariants) {
            return DEFAULT;
        }
        return SOUL;
    }
}

