/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.entity.HealthUtil;
import io.github.how_bout_no.outvoted.init.ModSounds;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class BarnacleEntity
extends Monster
implements IAnimatable {
    private static final EntityDataAccessor<Integer> ATTACKING;
    private static final EntityDataAccessor<Integer> TARGET_ENTITY;
    private LivingEntity targetedEntity;
    private static final Map<Integer, UUID> targetedEntities;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    protected RandomStrollGoal wander;
    private boolean initAttack = false;
    private int attackCounter = 0;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public BarnacleEntity(EntityType<? extends BarnacleEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
        this.wander = new RandomStrollGoal((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ChaseGoal(this, 6.0, 48.0f));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, BarnacleEntity.class, 72.0f, 4.0, 4.0));
        this.f_21345_.m_25352_(6, (Goal)movetowardsrestrictiongoal);
        this.f_21345_.m_25352_(7, (Goal)this.wander);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.wander.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Dolphin.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        HealthUtil.setConfigHealth((LivingEntity)this, Outvoted.commonConfig.entities.barnacle.health);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean canSpawn(EntityType<BarnacleEntity> entity, LevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        return blockPos.m_123342_() >= world.m_6924_(Heightmap.Types.OCEAN_FLOOR, blockPos.m_123341_(), blockPos.m_123343_()) && world.m_46791_() != Difficulty.PEACEFUL && (double)blockPos.m_123342_() <= 45.0 && (spawnReason == MobSpawnType.SPAWNER || world.m_6425_(blockPos).m_76153_((Tag)FluidTags.f_13131_));
    }

    public int m_5792_() {
        return 1;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ENTITY, (Object)0);
        this.f_19804_.m_135372_(ATTACKING, (Object)0);
    }

    public int getAttackDuration() {
        return 80;
    }

    private void setTargetedEntity(int entityId) {
        this.f_19804_.m_135381_(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ENTITY) != 0;
    }

    private void setAttacking(int attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public int getAttackPhase() {
        return (Integer)this.f_19804_.m_135370_(ATTACKING);
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.m_5448_();
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void updateAir(int air) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(air - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19312_, 5.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public int m_8100_() {
        return 160;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.BARNACLE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.BARNACLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BARNACLE_DEATH.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.4f;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_) ? 10.0f + worldIn.m_46863_(pos) - 0.5f : super.m_5610_(pos, worldIn);
    }

    public void m_6667_(DamageSource cause) {
        targetedEntities.remove(this.f_19804_.m_135370_(TARGET_ENTITY));
        super.m_6667_(cause);
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(strength / 4.0, x, z);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.f_19853_.f_46443_) {
                if (!this.m_20069_()) {
                    Vec3 vector3d = this.m_20184_();
                    if (vector3d.f_82480_ > 0.0 && this.clientSideTouchedGround && !this.m_20067_()) {
                        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlopSound(), this.m_5720_(), 1.0f, 1.0f, false);
                    }
                    boolean bl = this.clientSideTouchedGround = vector3d.f_82480_ < 0.0 && this.f_19853_.m_46575_(this.m_142538_().m_7495_(), (Entity)this);
                }
                if (this.hasTargetedEntity() && this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
            }
            if (this.hasTargetedEntity()) {
                this.m_146922_(this.f_20885_);
                LivingEntity livingentity = this.getTargetedEntity();
                if (livingentity != null) {
                    this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                    this.m_21563_().m_8128_();
                    double d5 = this.getAttackAnimationScale(0.0f);
                    double d0 = livingentity.m_20185_() - this.m_20185_();
                    double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                    double d2 = livingentity.m_20189_() - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.f_19796_.nextDouble();
                    if (this.getAttackPhase() == 0) {
                        this.setAttacking(1);
                    }
                    while (d4 < d3) {
                        d4 += 1.8 - d5 + this.f_19796_.nextDouble() * (1.7 - d5);
                        livingentity.m_7678_(this.m_20185_() + d0 * d3, this.m_20188_() + d1, this.m_20189_() + d2 * d3, livingentity.m_146908_(), livingentity.m_146909_());
                        livingentity.m_20282_(false);
                        livingentity.m_5844_();
                        if (!this.f_19853_.f_46443_ && livingentity.m_20159_() && livingentity.m_20201_() instanceof Boat) {
                            Entity boat = livingentity.m_20201_();
                            livingentity.m_8127_();
                            boat.m_19998_((ItemLike)((Boat)boat).m_38369_());
                            try {
                                Containers.m_18998_((Level)boat.f_19853_, (Entity)boat, (Container)((Container)boat));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boat.m_146870_();
                        }
                        if (this.getAttackPhase() != 0) {
                            if (this.attackCounter > 10) {
                                if (!this.initAttack) {
                                    livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 0.1f);
                                    this.initAttack = true;
                                }
                            } else {
                                ++this.attackCounter;
                            }
                            livingentity.m_5997_(-d0 / 50.0, -d1 / 50.0, -d2 / 50.0);
                            continue;
                        }
                        if (this.initAttack) {
                            this.initAttack = false;
                            continue;
                        }
                        this.attackCounter = 0;
                    }
                }
            }
            if (this.m_20072_()) {
                this.m_20301_(300);
            } else if (this.f_19861_) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.1f), 0.5, (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.1f)));
                this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
                this.f_19861_ = false;
                this.f_19812_ = true;
            }
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.updateAir(i);
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)ModSounds.BARNACLE_FLOP.get();
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.wander != null) {
            this.wander.m_25751_();
        }
        return super.m_6469_(source, amount);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_6113_() == 0.0f && this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.001, 0.0));
            } else if (this.m_5448_() != null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_21536_()) {
            this.m_21446_(this.m_142538_(), 96);
        }
    }

    public boolean waterCheck(LivingEntity livingentity) {
        if (livingentity.m_20202_() != null) {
            return livingentity.m_20202_().m_20069_();
        }
        return livingentity.m_20069_() && (targetedEntities.get(livingentity.m_142049_()) == null || targetedEntities.get(livingentity.m_142049_()) == this.m_142081_());
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int phase = this.getAttackPhase();
        LivingEntity livingEntity = this.getTargetedEntity();
        if (this.hasTargetedEntity() && phase > 0 && livingEntity != null && livingEntity.m_20182_() != null) {
            GeckoLibCache.getInstance().parser.setValue("distance", this.m_20280_((Entity)livingEntity) + 15.0);
        }
        if (event.getController().getCurrentAnimation() == null || event.getController().getCurrentAnimation().animationName == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("swim"));
            return PlayState.CONTINUE;
        }
        switch (phase) {
            case 1: {
                if (event.getController().getCurrentAnimation().animationName.equals("bite")) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("reelin"));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack").addAnimation("reelin"));
                }
                return PlayState.CONTINUE;
            }
            case 2: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("clamp"));
                return PlayState.CONTINUE;
            }
            case 3: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("bite"));
                return PlayState.CONTINUE;
            }
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("swim"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 3.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static {
        targetedEntities = new HashMap<Integer, UUID>();
        ATTACKING = SynchedEntityData.m_135353_(BarnacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TARGET_ENTITY = SynchedEntityData.m_135353_(BarnacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    static class MoveHelperController
    extends MoveControl {
        private final BarnacleEntity mob;

        public MoveHelperController(BarnacleEntity entity) {
            super((Mob)entity);
            this.mob = entity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.mob.m_21573_().m_26571_()) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
                double d0 = vector3d.m_82553_();
                double d1 = vector3d.f_82479_ / d0;
                double d2 = vector3d.f_82480_ / d0;
                double d3 = vector3d.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.2957763671875) - 90.0f;
                this.mob.m_146922_(this.m_24991_(this.mob.m_146908_(), f, 90.0f));
                this.mob.f_20883_ = this.mob.m_146908_();
                float f1 = (float)(this.f_24978_ * this.mob.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.mob.m_6113_(), (float)f1);
                this.mob.m_7910_(f2);
                double d4 = Math.sin((double)(this.mob.f_19797_ + this.mob.m_142049_()) * 0.5) * 0.05;
                double d5 = Math.cos(this.mob.m_146908_() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.mob.m_146908_() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.mob.f_19797_ + this.mob.m_142049_()) * 0.75) * 0.05;
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookControl lookcontroller = this.mob.m_21563_();
                double d8 = this.mob.m_20185_() + d1 * 2.0;
                double d9 = this.mob.m_20188_() + d2 / d0;
                double d10 = this.mob.m_20189_() + d3 * 2.0;
                double d11 = lookcontroller.m_24969_();
                double d12 = lookcontroller.m_24970_();
                double d13 = lookcontroller.m_24971_();
                if (!lookcontroller.m_24968_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.mob.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.mob.m_7910_(0.0f);
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final BarnacleEntity mob;
        private int tickCounter;
        private boolean hasAttacked;

        public AttackGoal(BarnacleEntity entity) {
            this.mob = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.mob.waterCheck(livingentity) && this.mob.m_20280_((Entity)this.mob.m_5448_()) < 64.0;
        }

        public boolean m_8045_() {
            if (this.mob.m_5448_() != null) {
                return this.mob.m_20280_((Entity)this.mob.m_5448_()) < 90.5 && this.mob.waterCheck(this.mob.m_5448_());
            }
            return false;
        }

        public void m_8056_() {
            this.tickCounter = -1;
            this.mob.m_21573_().m_26573_();
            this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 90.0f, 90.0f);
            this.mob.f_19812_ = true;
            this.hasAttacked = false;
        }

        public void m_8041_() {
            targetedEntities.remove(this.mob.f_19804_.m_135370_(TARGET_ENTITY));
            this.mob.setTargetedEntity(0);
            this.mob.m_6710_(null);
            this.mob.wander.m_25751_();
            this.mob.setAttacking(0);
            this.hasAttacked = false;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21573_().m_26573_();
                this.mob.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                if (!this.mob.m_142582_((Entity)livingentity)) {
                    this.mob.m_6710_(null);
                } else {
                    ++this.tickCounter;
                    if (this.mob.getAttackPhase() < 1) {
                        this.mob.setAttacking(1);
                    }
                    if (this.tickCounter == 0) {
                        this.mob.setTargetedEntity(this.mob.m_5448_().m_142049_());
                        targetedEntities.put(livingentity.m_142049_(), this.mob.m_142081_());
                    } else if (this.tickCounter >= this.mob.getAttackDuration()) {
                        if (this.tickCounter >= 600) {
                            this.mob.setAttacking(2);
                            if (this.tickCounter % 5 == 0) {
                                livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 2.0f);
                            }
                        } else if (this.tickCounter % 40 == 0 && this.mob.getAttackPhase() == 1) {
                            this.mob.setAttacking(3);
                        } else if (this.mob.getAttackPhase() == 3 && this.tickCounter % 6 == 0) {
                            if (!this.hasAttacked) {
                                livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 2.0f);
                            } else {
                                this.mob.setAttacking(1);
                            }
                            this.hasAttacked = !this.hasAttacked;
                        }
                    }
                }
            }
        }
    }

    static class ChaseGoal
    extends MoveTowardsTargetGoal {
        private final BarnacleEntity mob;
        private final double speed;

        public ChaseGoal(BarnacleEntity barnacle, double speedIn, float maxDistanceIn) {
            super((PathfinderMob)barnacle, speedIn, maxDistanceIn);
            this.mob = barnacle;
            this.speed = speedIn;
        }

        public void m_8041_() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                return super.m_8036_() && this.mob.waterCheck(livingentity) && this.mob.m_21533_();
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                return super.m_8045_() && this.mob.waterCheck(livingentity) && this.mob.m_21533_();
            }
            return false;
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speed);
            }
        }
    }
}

