/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.block.BaseCopperButtonBlock;
import io.github.how_bout_no.outvoted.entity.HealthUtil;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import io.github.how_bout_no.outvoted.util.ModUtil;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CopperGolemEntity
extends AbstractGolem
implements IAnimatable {
    protected static final EntityDataAccessor<Integer> OXIDIZATION_LEVEL = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> WAXED = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<CompoundTag> ROTATIONS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    protected boolean pushingState = false;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public CopperGolemEntity(EntityType<? extends CopperGolemEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new CGLookControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PushButtonsGoal((PathfinderMob)this, 0.8, 10));
        this.f_21345_.m_25352_(2, (Goal)new WanderGoal((PathfinderMob)this, 0.7, 75));
        this.f_21345_.m_25352_(3, (Goal)new LookEntityGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.9);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        HealthUtil.setConfigHealth((LivingEntity)this, Outvoted.commonConfig.entities.coppergolem.health);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OXIDIZATION_LEVEL, (Object)0);
        this.f_19804_.m_135372_(WAXED, (Object)false);
        this.f_19804_.m_135372_(ROTATIONS, (Object)new CompoundTag());
    }

    public void setOxidizationLevel(int level) {
        this.f_19804_.m_135381_(OXIDIZATION_LEVEL, (Object)level);
    }

    public int getOxidizationLevel() {
        return (Integer)this.f_19804_.m_135370_(OXIDIZATION_LEVEL);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(WAXED, (Object)waxed);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED);
    }

    public void setRotations(float[] inp) {
        float[] rot = (float[])inp.clone();
        int i = 0;
        while (i < rot.length) {
            int n = i++;
            rot[n] = rot[n] * 10000.0f;
        }
        this.setRotationsI(ModUtil.toIntArray(rot));
    }

    public void setRotationsI(int[] inp) {
        if (inp == null) {
            inp = new int[7];
        }
        CompoundTag compound = new CompoundTag();
        compound.m_128385_("Rot", inp);
        this.f_19804_.m_135381_(ROTATIONS, (Object)compound);
    }

    public float[] getRotations() {
        float[] rot = ModUtil.toFloatArray((int[])this.getRotationsI().clone());
        int i = 0;
        while (i < rot.length) {
            int n = i++;
            rot[n] = rot[n] / 10000.0f;
        }
        return rot;
    }

    public int[] getRotationsI() {
        int[] rots = ((CompoundTag)this.f_19804_.m_135370_(ROTATIONS)).m_128465_("Rot");
        if (rots.length < 7) {
            rots = new int[7];
        }
        return rots;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() - 0.1, 0.0);
    }

    public float getOxidizationMultiplier() {
        return switch (this.getOxidizationLevel()) {
            case 0 -> 1.0f;
            case 1 -> 0.75f;
            case 2 -> 0.5f;
            case 3 -> 0.0f;
            default -> throw new IllegalStateException("Unexpected value: " + this.getOxidizationLevel());
        };
    }

    public boolean isNotFrozen() {
        return this.getOxidizationLevel() < 3;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    protected float m_6059_() {
        return (int)this.f_19788_ + 1;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.7f;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Oxidization", this.getOxidizationLevel());
        compound.m_128379_("Waxed", this.isWaxed());
        compound.m_128385_("Rotations", (int[])this.getRotationsI().clone());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setOxidizationLevel(compound.m_128451_("Oxidization"));
        this.setWaxed(compound.m_128471_("Waxed"));
        this.setRotationsI(compound.m_128465_("Rotations"));
    }

    public static boolean canSpawn(EntityType<CopperGolemEntity> entity, LevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        return CopperGolemEntity.m_21400_(entity, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
        this.unFreeze();
        this.setOxidizationLevel(0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && !this.isWaxed() && this.f_19797_ % (int)Math.max(Math.pow(35 * this.f_19853_.m_46469_().m_46215_(GameRules.f_46143_), -0.5), 1.0) == 0 && this.f_19796_.nextFloat() < Outvoted.commonConfig.entities.coppergolem.oxidationRate) {
            this.oxidize();
        }
    }

    public float[] createRot() {
        float limbSwing = this.f_20925_;
        float limbSwingAmount = this.f_20924_;
        float oxidizeMult = this.getOxidizationMultiplier();
        if (oxidizeMult < 1.0f && oxidizeMult > 0.0f) {
            oxidizeMult += 0.25f;
        }
        float f = Mth.m_14189_((float)0.0f, (float)this.f_20884_, (float)this.f_20883_);
        float f1 = Mth.m_14189_((float)0.0f, (float)this.f_20886_, (float)this.f_20885_);
        float[] rot = new float[]{this.m_146909_(), f1 - f, Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult)) * 2.0f * limbSwingAmount, Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult + (float)Math.PI)) * 2.0f * limbSwingAmount, Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult + (float)Math.PI)) * 2.0f * limbSwingAmount, Mth.m_14089_((float)(limbSwing * 1.0f * oxidizeMult)) * 2.0f * limbSwingAmount, this.m_146908_()};
        return rot;
    }

    public void m_19915_(float yaw, float pitch) {
        super.m_19915_(yaw, pitch);
        if (!this.isNotFrozen()) {
            this.f_20885_ = yaw;
            this.f_20883_ = yaw;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getOxidizationLevel() == 2) {
            this.setRotations(this.createRot());
        } else if (!this.isNotFrozen()) {
            this.m_19915_(this.getRotations()[6], this.m_146909_());
        }
    }

    public float m_6113_() {
        return super.m_6113_() * this.getOxidizationMultiplier();
    }

    public void oxidize() {
        if (this.getOxidizationLevel() < 3) {
            this.setOxidizationLevel(this.getOxidizationLevel() + 1);
        }
        if (this.getOxidizationLevel() == 3) {
            this.freeze();
        }
    }

    public void deOxidize() {
        if (this.getOxidizationLevel() - 1 == 2) {
            this.unFreeze();
        }
        this.setOxidizationLevel(this.getOxidizationLevel() - 1);
    }

    public void freeze() {
        this.setOxidizationLevel(3);
        this.m_21557_(true);
        this.m_21573_().m_26517_(0.0);
        this.m_21573_().m_26573_();
        this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0);
        this.m_21566_().m_8126_();
    }

    public void unFreeze() {
        this.m_21557_(false);
        this.m_21573_().m_26517_(1.0);
    }

    protected void m_7324_(Entity entity) {
        if (this.isNotFrozen()) {
            super.m_7324_(entity);
        }
    }

    public void m_7334_(Entity entity) {
        if (this.isNotFrozen()) {
            super.m_7334_(entity);
        }
    }

    public boolean m_6094_() {
        return super.m_6094_() && this.isNotFrozen();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean ci = itemStack.m_150930_(Items.f_151052_);
        boolean ai = itemStack.m_41720_() instanceof AxeItem;
        boolean hi = itemStack.m_150930_(Items.f_42784_);
        if (!(ci || ai || hi)) {
            return InteractionResult.PASS;
        }
        if (ci) {
            float f = this.m_21223_();
            this.m_5634_(this.m_21233_() / 4.0f);
            if (this.m_21223_() == f) {
                return InteractionResult.PASS;
            }
            float g = 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f;
            this.m_5496_(SoundEvents.f_12009_, 1.0f, g);
        } else if (ai) {
            if (this.isWaxed()) {
                this.setWaxed(false);
                this.m_5496_(SoundEvents.f_144060_, 1.0f, 1.0f);
                this.f_19853_.m_46796_(3004, this.m_142538_(), 0);
            } else {
                if (this.getOxidizationLevel() <= 0) return InteractionResult.PASS;
                this.deOxidize();
                this.m_5496_(SoundEvents.f_144059_, 1.0f, 1.0f);
                this.f_19853_.m_46796_(3005, this.m_142538_(), 0);
            }
        } else {
            if (this.isWaxed()) return InteractionResult.PASS;
            this.setWaxed(true);
            this.m_5496_(SoundEvents.f_144178_, 1.0f, 1.0f);
            this.f_19853_.m_46796_(3003, this.m_142538_(), 0);
        }
        this.m_146859_(GameEvent.f_157771_, this.m_146901_());
        if (player.m_150110_().f_35937_) return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (ci || hi) {
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        } else {
            if (this.f_19853_.f_46443_) return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            itemStack.m_41629_(1, this.f_19796_, (ServerPlayer)player);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean m_6914_(LevelReader world) {
        BlockPos blockPos = this.m_142538_();
        BlockPos blockPos2 = blockPos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos2);
        if (!blockState.m_60634_((BlockGetter)world, blockPos2, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 2; ++i) {
            BlockState blockState2;
            BlockPos blockPos3 = blockPos.m_6630_(i);
            if (NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)blockPos3, (BlockState)(blockState2 = world.m_8055_(blockPos3)), (FluidState)blockState2.m_60819_(), (EntityType)((EntityType)ModEntityTypes.COPPER_GOLEM.get()))) continue;
            return false;
        }
        return NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)blockPos, (BlockState)world.m_8055_(blockPos), (FluidState)Fluids.f_76191_.m_76145_(), (EntityType)((EntityType)ModEntityTypes.COPPER_GOLEM.get())) && world.m_45784_((Entity)this);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 1.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class CGLookControl
    extends LookControl {
        public CGLookControl(Mob mobEntity) {
            super(mobEntity);
        }

        public void m_8128_() {
            if (CopperGolemEntity.this.isNotFrozen()) {
                super.m_8128_();
            }
        }
    }

    static class PushButtonsGoal
    extends MoveToBlockGoal {
        public PushButtonsGoal(PathfinderMob pathAwareEntity, double d, int i) {
            super(pathAwareEntity, d, i);
        }

        protected int m_6099_(PathfinderMob mob) {
            return 100 + mob.m_21187_().nextInt(200);
        }

        public double m_8052_() {
            return 0.75;
        }

        public boolean m_8036_() {
            return super.m_8036_() && ((CopperGolemEntity)this.f_25598_).isNotFrozen();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_25600_ == 0 && ((CopperGolemEntity)this.f_25598_).isNotFrozen();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_()) {
                ((CopperGolemEntity)this.f_25598_).pushingState = true;
                this.f_25600_ = this.m_6099_(this.f_25598_);
                BlockState state = this.f_25598_.f_19853_.m_8055_(this.f_25602_);
                ((ButtonBlock)state.m_60734_()).m_6227_(state, this.f_25598_.f_19853_, this.f_25602_, null, null, null);
            }
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            BlockState blockState = world.m_8055_(pos);
            return blockState.m_60734_() instanceof BaseCopperButtonBlock;
        }
    }

    static class WanderGoal
    extends RandomStrollGoal {
        public WanderGoal(PathfinderMob pathAwareEntity, double d, int i) {
            super(pathAwareEntity, d, i);
        }

        public boolean m_8036_() {
            return super.m_8036_() && ((CopperGolemEntity)this.f_25725_).isNotFrozen();
        }

        public boolean m_8045_() {
            return super.m_8045_() && ((CopperGolemEntity)this.f_25725_).isNotFrozen();
        }
    }

    static class LookEntityGoal
    extends LookAtPlayerGoal {
        public LookEntityGoal(Mob mobEntity, Class<? extends LivingEntity> class_, float f) {
            super(mobEntity, class_, f);
        }

        public boolean m_8036_() {
            return super.m_8036_() && ((CopperGolemEntity)this.f_25512_).isNotFrozen();
        }

        public boolean m_8045_() {
            return super.m_8045_() && ((CopperGolemEntity)this.f_25512_).isNotFrozen();
        }
    }

    static class LookGoal
    extends Goal {
        private final Mob mob;
        private double deltaX;
        private double deltaZ;
        private int lookTime;

        public LookGoal(Mob mobEntity) {
            this.mob = mobEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_21187_().nextFloat() < 0.02f && ((CopperGolemEntity)this.mob).isNotFrozen();
        }

        public boolean m_8045_() {
            return this.lookTime >= 0 && ((CopperGolemEntity)this.mob).isNotFrozen();
        }

        public void m_8056_() {
            double d = Math.PI * 2 * this.mob.m_21187_().nextDouble();
            this.deltaX = Math.cos(d);
            this.deltaZ = Math.sin(d);
            this.lookTime = 20 + this.mob.m_21187_().nextInt(20);
        }

        public void m_8037_() {
            --this.lookTime;
            this.mob.m_21563_().m_24946_(this.mob.m_20185_() + this.deltaX, this.mob.m_20188_(), this.mob.m_20189_() + this.deltaZ);
        }
    }
}

