/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.entity.HealthUtil;
import io.github.how_bout_no.outvoted.util.ItemPlacementContextLiving;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class GlareEntity
extends PathfinderMob
implements IAnimatable {
    public static final int maxLight = 7;
    public static int inventorySize = Outvoted.commonConfig.entities.glare.inventorySize;
    @Nullable
    protected BlockPos darkPos;
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    static final Predicate<ItemEntity> PICKABLE_DROP_FILTER = item -> {
        if (item.m_32055_().m_41720_() instanceof BlockItem) {
            BlockState state = ((BlockItem)item.m_32055_().m_41720_()).m_40614_().m_49966_();
            return !item.m_32063_() && item.m_6084_() && state.m_60791_() > 7;
        }
        return false;
    };
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public GlareEntity(EntityType<? extends GlareEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21553_(Outvoted.commonConfig.entities.glare.shouldInteract);
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_46859_(pos) ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151079_}), false));
        if (Outvoted.commonConfig.entities.glare.shouldInteract) {
            this.f_21345_.m_25352_(1, (Goal)new PickupItemGoal());
            this.f_21345_.m_25352_(2, (Goal)new InDarkGoal());
        }
        this.f_21345_.m_25352_(3, (Goal)new MoveToDarkGoal());
        this.f_21345_.m_25352_(4, (Goal)new FindDarkSpotGoal());
        this.f_21345_.m_25352_(5, (Goal)new GlareWanderAroundGoal());
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, 0.4000000238418579).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        HealthUtil.setConfigHealth((LivingEntity)this, Outvoted.commonConfig.entities.glare.health);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_46859_(pos.m_7495_());
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsAngry", this.isAngry());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAngry(compound.m_128471_("IsAngry"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)Boolean.FALSE);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.7f;
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(ANGRY, (Object)angry);
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(equipmentSlot).m_41619_()) {
            return false;
        }
        return equipmentSlot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack stack) {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
    }

    private void dropItem(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.f_19853_.m_7967_((Entity)itemEntity);
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack itemStack = item.m_32055_();
        if (this.m_7252_(itemStack)) {
            int i = itemStack.m_41613_();
            if (i > inventorySize) {
                this.dropItem(itemStack.m_41620_(i - inventorySize));
            }
            this.m_21053_(item);
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_41620_(inventorySize));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)item, itemStack.m_41613_());
            item.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.setAngry(this.getLight(this.m_142538_()) <= 7);
        }
        if (this.isAngry() && this.f_19797_ % 20 == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(0.75), this.m_20186_() + this.f_19796_.nextDouble(), this.m_20262_(0.75), this.f_19796_.nextDouble(), this.f_19796_.nextDouble(), this.f_19796_.nextDouble());
        }
        if (this.isAngry() && this.f_19797_ % 15 == 0) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_144055_, SoundSource.NEUTRAL, 0.6f, Mth.m_14179_((float)this.f_19796_.nextFloat(), (float)0.25f, (float)0.75f));
        }
    }

    void startMovingTo(BlockPos pos) {
        Vec3 vec3d2;
        Vec3 vec3d = Vec3.m_82539_((Vec3i)pos);
        int i = 0;
        BlockPos blockPos = this.m_142538_();
        int j = (int)vec3d.f_82480_ - blockPos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.m_123333_((Vec3i)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3d, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, 1.0);
        }
    }

    public boolean hasDarkPos() {
        return this.darkPos != null;
    }

    public boolean isDarkSpot(BlockPos pos) {
        return this.getLight(pos) <= 7 && this.f_19853_.m_46859_(pos);
    }

    boolean isWithinDistance(BlockPos pos, int distance) {
        return this.isWithinDistance(pos, (double)distance);
    }

    boolean isWithinDistance(BlockPos pos, double distance) {
        return pos.m_123314_((Vec3i)this.m_142538_(), distance);
    }

    boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos, 32);
    }

    int getLight(BlockPos pos) {
        return this.f_19853_.m_45524_(pos, this.f_19853_.m_7445_());
    }

    private static boolean isSuitableSpawn(LevelAccessor world, BlockPos pos, Random random) {
        int mult = 5;
        for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)pos, (int)mult, (int)mult, (int)mult)) {
            BlockState state = world.m_8055_(blockPos);
            if (!state.m_60819_().m_76153_((Tag)FluidTags.f_13132_)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpawn(EntityType<GlareEntity> entity, LevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        return !world.m_45527_(blockPos) && GlareEntity.isSuitableSpawn(world, blockPos, random) && blockPos.m_123342_() < 63 && GlareEntity.m_21400_(entity, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        GeckoLibCache.getInstance().parser.setValue("mult", this.isAngry() ? (double)0.6f : (double)0.2f);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("living", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class PickupItemGoal
    extends Goal {
        public PickupItemGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!Outvoted.commonConfig.entities.glare.shouldInteract || !GlareEntity.this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                return false;
            }
            if (GlareEntity.this.m_5448_() == null && GlareEntity.this.m_142581_() == null) {
                if (GlareEntity.this.m_21187_().nextInt(10) != 0) {
                    return false;
                }
                List list = GlareEntity.this.f_19853_.m_6443_(ItemEntity.class, GlareEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
                return !list.isEmpty() && GlareEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public boolean m_8045_() {
            return (!Outvoted.commonConfig.entities.glare.shouldInteract || !GlareEntity.this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) && super.m_8045_();
        }

        public void m_8037_() {
            List list = GlareEntity.this.f_19853_.m_6443_(ItemEntity.class, GlareEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            ItemStack itemStack = GlareEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemStack.m_41619_() && !list.isEmpty()) {
                GlareEntity.this.m_21573_().m_5624_((Entity)list.get(0), 1.2);
            }
        }

        public void m_8056_() {
            List list = GlareEntity.this.f_19853_.m_6443_(ItemEntity.class, GlareEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                GlareEntity.this.m_21573_().m_5624_((Entity)list.get(0), 1.2);
            }
        }
    }

    class InDarkGoal
    extends Goal {
        private int tick;

        InDarkGoal() {
        }

        public boolean m_8036_() {
            if (GlareEntity.this.isDarkSpot(GlareEntity.this.m_142538_())) {
                GlareEntity.this.darkPos = GlareEntity.this.m_142538_();
            }
            return GlareEntity.this.darkPos != null && !GlareEntity.this.m_21536_() && GlareEntity.this.m_142538_() == GlareEntity.this.darkPos;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (GlareEntity.this.darkPos != null && this.tick >= 5 && !GlareEntity.this.m_21205_().m_41619_() && GlareEntity.this.isDarkSpot(GlareEntity.this.m_142538_())) {
                ItemPlacementContextLiving itemPlacementContextLiving;
                BlockItem blockItem = (BlockItem)GlareEntity.this.m_21205_().m_41720_();
                InteractionResult actionResult = blockItem.m_40576_((BlockPlaceContext)(itemPlacementContextLiving = new ItemPlacementContextLiving(GlareEntity.this.f_19853_, (LivingEntity)GlareEntity.this, GlareEntity.this.m_7655_(), GlareEntity.this.m_21205_(), new BlockHitResult(Vec3.m_82512_((Vec3i)GlareEntity.this.m_142538_()), GlareEntity.this.m_6374_(), GlareEntity.this.m_142538_(), !GlareEntity.this.f_19853_.m_46859_(GlareEntity.this.m_142538_())))));
                if (!actionResult.m_19077_()) {
                    for (Direction direction : Direction.values()) {
                        BlockPos blockPos = GlareEntity.this.m_142538_().m_142300_(direction);
                        if (GlareEntity.this.f_19853_.m_46859_(blockPos) && GlareEntity.this.isDarkSpot(blockPos) && (actionResult = blockItem.m_40576_((BlockPlaceContext)(itemPlacementContextLiving = new ItemPlacementContextLiving(GlareEntity.this.f_19853_, (LivingEntity)GlareEntity.this, GlareEntity.this.m_7655_(), GlareEntity.this.m_21205_(), new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos), GlareEntity.this.m_6374_(), blockPos, !GlareEntity.this.f_19853_.m_46859_(blockPos)))))).m_19077_()) break;
                    }
                }
                if (actionResult.m_19077_()) {
                    GlareEntity.this.m_21205_().m_41774_(1);
                    this.tick = 0;
                }
            }
            ++this.tick;
        }
    }

    class MoveToDarkGoal
    extends Goal {
        int ticks;

        MoveToDarkGoal() {
            this.ticks = GlareEntity.this.f_19853_.f_46441_.nextInt(10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return GlareEntity.this.darkPos != null && !GlareEntity.this.m_21536_() && GlareEntity.this.m_142538_() != GlareEntity.this.darkPos && !GlareEntity.this.m_21523_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.ticks = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.ticks = 0;
            GlareEntity.this.f_21344_.m_26573_();
            GlareEntity.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (GlareEntity.this.darkPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    GlareEntity.this.darkPos = null;
                } else if (!GlareEntity.this.f_21344_.m_26572_()) {
                    if (GlareEntity.this.isTooFar(GlareEntity.this.darkPos)) {
                        GlareEntity.this.darkPos = null;
                    } else {
                        GlareEntity.this.startMovingTo(GlareEntity.this.darkPos);
                    }
                }
            }
        }
    }

    class FindDarkSpotGoal
    extends Goal {
        int ticks;

        FindDarkSpotGoal() {
            this.ticks = GlareEntity.this.f_19853_.f_46441_.nextInt(20) + 20;
        }

        public boolean m_8036_() {
            ++this.ticks;
            return (!GlareEntity.this.hasDarkPos() || !GlareEntity.this.isDarkSpot(GlareEntity.this.darkPos)) && this.ticks > 40;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.ticks = 0;
            BlockPos darkestSpot = this.getDarkestSpot();
            if (darkestSpot != null) {
                GlareEntity.this.darkPos = darkestSpot;
            }
        }

        private Map<BlockPos, Integer> getNearbyDarkSpots() {
            int mult = 5;
            HashMap<BlockPos, Integer> map = new HashMap<BlockPos, Integer>();
            for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)GlareEntity.this.m_142538_(), (int)mult, (int)mult, (int)mult)) {
                if (!GlareEntity.this.isDarkSpot(blockPos) || blockPos.m_123342_() < 4) continue;
                map.put(blockPos.m_7949_(), GlareEntity.this.getLight(blockPos));
            }
            return map;
        }

        @Nullable
        private BlockPos getDarkestSpot() {
            Map<BlockPos, Integer> map = this.getNearbyDarkSpots();
            BlockPos returnPos = null;
            if (!map.isEmpty()) {
                Map.Entry min = Collections.min(map.entrySet(), Map.Entry.comparingByValue());
                returnPos = (BlockPos)min.getKey();
            }
            return returnPos;
        }
    }

    class GlareWanderAroundGoal
    extends Goal {
        private static final int MAX_DISTANCE = 22;

        GlareWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return GlareEntity.this.f_21344_.m_26571_() && GlareEntity.this.f_19796_.nextInt(20) == 0;
        }

        public boolean m_8045_() {
            return GlareEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                GlareEntity.this.f_21344_.m_26536_(GlareEntity.this.f_21344_.m_7864_(new BlockPos(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d3 = GlareEntity.this.m_20252_(0.0f);
            Vec3 vec3d4 = HoverRandomPos.m_148465_((PathfinderMob)GlareEntity.this, (int)8, (int)7, (double)vec3d3.f_82479_, (double)vec3d3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d4 != null ? vec3d4 : AirAndWaterRandomPos.m_148357_((PathfinderMob)GlareEntity.this, (int)8, (int)4, (int)-2, (double)vec3d3.f_82479_, (double)vec3d3.f_82481_, (double)1.5707963705062866);
        }
    }
}

