/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import com.google.common.collect.ImmutableList;
import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.entity.HealthUtil;
import io.github.how_bout_no.outvoted.init.ModItems;
import io.github.how_bout_no.outvoted.init.ModSounds;
import io.github.how_bout_no.outvoted.init.ModTags;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ArrowInfiniteEnchantment;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GluttonEntity
extends PathfinderMob
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> BURROWED = SynchedEntityData.m_135353_(GluttonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(GluttonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ENCHANTING = SynchedEntityData.m_135353_(GluttonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(GluttonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected Map<Enchantment, Integer> storedEnchants = new HashMap<Enchantment, Integer>();
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public GluttonEntity(EntityType<? extends GluttonEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BiteGoal(this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new BurrowGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FindSpotGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WanderGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, GluttonEntity.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> this.m_20280_((Entity)entity) < 2.0 && !(entity instanceof Creeper)));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        HealthUtil.setConfigHealth((LivingEntity)this, Outvoted.commonConfig.entities.glutton.health);
        Block block = worldIn.m_8055_(this.m_20099_()).m_60734_();
        this.setVariant(block == Blocks.f_49992_ ? 0 : (block == Blocks.f_49993_ ? 1 : 2));
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return 0.0f;
    }

    public static boolean canSpawn(EntityType<GluttonEntity> entity, LevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        return world.m_45524_(blockPos, 0) > 8 && GluttonEntity.m_21400_(entity, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (Random)random) && world.m_8055_(blockPos.m_7495_()).m_60620_(ModTags.Blocks.GLUTTON_CAN_BURROW);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GLUTTON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.GLUTTON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GLUTTON_DEATH.get();
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected float m_6121_() {
        return this.isBurrowed() ? 0.25f : super.m_6121_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        ItemStack item = ItemStack.f_41583_;
        EnchantmentHelper.m_44865_(this.storedEnchants, (ItemStack)item);
        CompoundTag compoundNBT = new CompoundTag();
        item.m_41739_(compoundNBT);
        compound.m_128365_("Enchantments", (net.minecraft.nbt.Tag)compoundNBT);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        ItemStack item = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Enchantments"));
        this.storedEnchants = EnchantmentHelper.m_44882_((ListTag)item.m_41785_());
    }

    protected Component m_5677_() {
        return switch (this.getVariant()) {
            case 1 -> new TranslatableComponent("entity.outvoted.glutton_r");
            case 2 -> new TranslatableComponent("entity.outvoted.glutton_s");
            default -> super.m_5677_();
        };
    }

    public int m_5792_() {
        return 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURROWED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ATTACKING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ENCHANTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void setBurrowed(boolean burrowed) {
        this.f_19804_.m_135381_(BURROWED, (Object)burrowed);
    }

    public boolean isBurrowed() {
        return (Boolean)this.f_19804_.m_135370_(BURROWED);
    }

    public void m_21561_(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean m_5912_() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setEnchanting(boolean enchanting) {
        this.f_19804_.m_135381_(ENCHANTING, (Object)enchanting);
    }

    public boolean isEnchanting() {
        return (Boolean)this.f_19804_.m_135370_(ENCHANTING);
    }

    public void setVariant(int type) {
        this.f_19804_.m_135381_(VARIANT, (Object)type);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public MutablePair<Integer, ItemStack> modifyEnchantments(ItemStack stack, int damage, int count) {
        ItemStack itemstack = stack.m_41777_();
        ConcurrentHashMap<Enchantment, Integer> cacheEnchants = new ConcurrentHashMap<Enchantment, Integer>(this.storedEnchants);
        itemstack.m_41749_("Enchantments");
        itemstack.m_41749_("StoredEnchantments");
        if (damage > 0) {
            itemstack.m_41721_(damage);
        } else {
            itemstack.m_41749_("Damage");
        }
        if (itemstack.m_41720_() == Items.f_42517_) {
            itemstack = new ItemStack((ItemLike)Items.f_42690_);
        }
        MutablePair pair = new MutablePair((Object)0, (Object)itemstack);
        if (this.storedEnchants.size() <= Outvoted.commonConfig.entities.glutton.maxEnchants) {
            itemstack.m_41764_(count);
            boolean[] hasCurses = new boolean[]{false};
            Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(enchant -> {
                if (((Enchantment)enchant.getKey()).m_6589_()) {
                    hasCurses[0] = true;
                }
                return !((Enchantment)enchant.getKey()).m_6589_();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (hasCurses[0]) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 600, 1));
                pair.setLeft((Object)1);
                return pair;
            }
            if (itemstack.m_41783_() != null && itemstack.m_41783_().m_128471_("Bitten") && Outvoted.commonConfig.entities.glutton.capEnchants) {
                pair.setLeft((Object)1);
                return pair;
            }
            if (!(itemstack.m_41792_() || itemstack.m_41793_() || itemstack.m_41720_() instanceof EnchantedBookItem)) {
                pair.setRight((Object)ItemStack.f_41583_);
                return pair;
            }
            if (itemstack.m_41720_().equals(ModItems.VOID_HEART.get())) {
                return pair;
            }
            if (!map.isEmpty()) {
                for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
                    Enchantment enchantment = entry.getKey();
                    Integer level = entry.getValue();
                    if (cacheEnchants.containsKey(enchantment)) {
                        if (!(enchantment.m_6586_() == 1 || Outvoted.commonConfig.entities.glutton.capEnchants && (Integer)cacheEnchants.get(enchantment) >= enchantment.m_6586_() + 1)) {
                            if (level.intValue() == enchantment.m_6586_() && ((Integer)cacheEnchants.get(enchantment)).intValue() == enchantment.m_6586_()) {
                                for (Enchantment ench : cacheEnchants.keySet()) {
                                    if ((Integer)cacheEnchants.get(ench) != ench.m_6586_() + 1) continue;
                                    pair.setLeft((Object)1);
                                    return pair;
                                }
                                cacheEnchants.put(enchantment, enchantment.m_6586_() + 1);
                                continue;
                            }
                            if (level.equals(cacheEnchants.get(enchantment))) {
                                cacheEnchants.put(enchantment, level + 1);
                                continue;
                            }
                            if (level <= (Integer)cacheEnchants.get(enchantment)) continue;
                            cacheEnchants.put(enchantment, level);
                            continue;
                        }
                        pair.setLeft((Object)1);
                        return pair;
                    }
                    if (!this.storedEnchants.isEmpty()) {
                        if (this.storedEnchants.size() < Outvoted.commonConfig.entities.glutton.maxEnchants) {
                            for (Enchantment ench : this.storedEnchants.keySet()) {
                                if (enchantment instanceof ProtectionEnchantment && ench instanceof ProtectionEnchantment) {
                                    if (((ProtectionEnchantment)enchantment).m_5975_(ench)) {
                                        cacheEnchants.put(enchantment, level);
                                        continue;
                                    }
                                    pair.setLeft((Object)1);
                                    return pair;
                                }
                                if (enchantment instanceof ArrowInfiniteEnchantment || enchantment instanceof MendingEnchantment) {
                                    cacheEnchants.put(enchantment, level);
                                    continue;
                                }
                                if (enchantment instanceof DamageEnchantment && ench instanceof DamageEnchantment) {
                                    cacheEnchants.put(enchantment, level);
                                    continue;
                                }
                                if (enchantment.m_44695_(ench)) {
                                    cacheEnchants.put(enchantment, level);
                                    continue;
                                }
                                pair.setLeft((Object)1);
                                return pair;
                            }
                            continue;
                        }
                        pair.setLeft((Object)1);
                        return pair;
                    }
                    cacheEnchants.put(enchantment, level);
                }
            } else {
                if (!this.storedEnchants.isEmpty()) {
                    pair.setLeft((Object)2);
                    map = this.storedEnchants;
                    this.storedEnchants = new HashMap<Enchantment, Integer>();
                    EnchantmentHelper.m_44865_(map, (ItemStack)itemstack);
                    return pair;
                }
                pair.setRight((Object)ItemStack.f_41583_);
            }
            this.storedEnchants = cacheEnchants;
        } else {
            pair.setLeft((Object)1);
        }
        return pair;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) && !source.f_19326_.equals("wither") && !source.m_19387_() && !source.m_19372_();
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
        super.m_147240_(this.isBurrowed() ? 0.0 : strength, ratioX, ratioZ);
    }

    public boolean m_6094_() {
        return !this.isBurrowed() && super.m_6094_();
    }

    public boolean m_7327_(Entity entityIn) {
        Entity entity;
        boolean exec = super.m_7327_(entityIn);
        if (exec && (entity = entityIn) instanceof Player) {
            Player player = (Player)entity;
            if (Outvoted.commonConfig.entities.glutton.stealEnchants) {
                ImmutableList allInventories = ImmutableList.of((Object)player.m_150109_().f_35974_, (Object)player.m_150109_().f_35975_, (Object)player.m_150109_().f_35976_);
                ArrayList<ItemStack> enchantedItems = new ArrayList<ItemStack>();
                for (NonNullList inv : allInventories) {
                    enchantedItems.addAll(inv.stream().filter(item -> !EnchantmentHelper.m_44831_((ItemStack)item).isEmpty()).collect(Collectors.toList()));
                }
                enchantedItems.removeIf(item -> item.m_41720_() instanceof AirItem);
                if (!enchantedItems.isEmpty()) {
                    ItemStack item2 = (ItemStack)enchantedItems.get(this.f_19796_.nextInt(enchantedItems.size()));
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)item2);
                    item2.m_41749_("Enchantments");
                    item2.m_41749_("StoredEnchantments");
                    Object[] enchants = enchantments.keySet().toArray();
                    Enchantment enchant = (Enchantment)enchants[this.f_19796_.nextInt(enchants.length)];
                    if ((Integer)enchantments.get(enchant) > 1) {
                        enchantments.put(enchant, (Integer)enchantments.get(enchant) - 1);
                    } else {
                        enchantments.remove(enchant);
                    }
                    if (enchantments.isEmpty() && item2.m_41720_() instanceof EnchantedBookItem) {
                        for (NonNullList inv : allInventories) {
                            if (!inv.contains((Object)item2)) continue;
                            inv.set(inv.indexOf((Object)item2), (Object)new ItemStack((ItemLike)Items.f_42517_));
                        }
                    } else {
                        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)item2);
                    }
                }
            }
        }
        return exec;
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            this.m_20331_(this.isBurrowed());
        }
        super.m_8107_();
    }

    public boolean isSuitable(GluttonEntity gluttonIn, @Nullable BlockPos pos) {
        double posZ;
        double posY;
        double posX;
        if (this.m_21124_(MobEffects.f_19615_) != null) {
            return false;
        }
        Level world = gluttonIn.f_19853_;
        if (pos == null) {
            posX = gluttonIn.m_20185_();
            posY = gluttonIn.m_20186_();
            posZ = gluttonIn.m_20189_();
        } else {
            posX = pos.m_123341_();
            posY = pos.m_123342_();
            posZ = pos.m_123343_();
        }
        boolean ret = true;
        block0: for (double k = posX - 1.0; k <= posX + 1.0 && ret; k += 1.0) {
            for (double l = posZ - 1.0; l <= posZ + 1.0; l += 1.0) {
                BlockState block = world.m_8055_(new BlockPos(k, posY - 1.0, l));
                if (block.m_60620_(ModTags.Blocks.GLUTTON_CAN_BURROW) && !gluttonIn.m_20069_()) {
                    if (!ret) continue;
                    ret = !gluttonIn.m_21523_();
                    continue;
                }
                ret = false;
                continue block0;
            }
        }
        return ret;
    }

    private Vec3 directionVector() {
        Vec3 vec3d = Vec3.f_82478_;
        double rotation = this.m_146908_() - 180.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        int ordinal = Mth.m_14107_((double)(rotation / 45.0 + 0.5)) & 7;
        for (Direction direction : Direction8.values()[ordinal].m_122593_()) {
            vec3d = vec3d.m_82520_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
        }
        return vec3d;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        String animname;
        String string = animname = event.getController().getCurrentAnimation() != null ? event.getController().getCurrentAnimation().animationName : "";
        if (this.isBurrowed()) {
            if (this.isEnchanting()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("bite").addAnimation("biteloop", Boolean.valueOf(true)));
            } else if (event.getController().getCurrentAnimation() != null) {
                if (animname.equals("idle") || animname.equals("attacking") || animname.equals("chomp") || animname.equals("burrow")) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("burrow").addAnimation("burrowed", Boolean.valueOf(true)));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("burrowed", Boolean.valueOf(true)));
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("burrow").addAnimation("burrowed", Boolean.valueOf(true)));
            }
        } else if (event.getController().getCurrentAnimation() == null || animname.equals("idle") || animname.equals("attacking")) {
            if (this.m_5912_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking"));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
            }
        } else if (this.m_5912_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("chomp").addAnimation("attacking"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("chomp").addAnimation("idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> void soundListener(SoundKeyframeEvent<E> event) {
        if (event.sound.equals("chomp")) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.GLUTTON_BITE.get(), this.m_5720_(), 1.0f, 1.0f, false);
        } else if (event.sound.equals("dig")) {
            BlockState block = this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - 0.5, this.m_20189_()));
            if (block.m_60620_((Tag)BlockTags.f_13029_)) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.GLUTTON_DIG_SAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            } else {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.GLUTTON_DIG.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    private <E extends IAnimatable> void particleListener(ParticleKeyFrameEvent<E> event) {
        if (event.effect.equals("dig")) {
            for (int i = 0; i < 2; ++i) {
                BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_20186_() - 0.5, this.m_20189_());
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), this.m_20208_(0.5), this.m_20227_(0.0), this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate);
        controller.registerSoundListener(this::soundListener);
        controller.registerParticleListener(this::particleListener);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class BiteGoal
    extends MeleeAttackGoal {
        private final GluttonEntity mob;

        public BiteGoal(GluttonEntity entityIn, double speedIn, boolean useMemory) {
            super((PathfinderMob)entityIn, speedIn, useMemory);
            this.mob = entityIn;
        }

        public boolean m_8036_() {
            this.mob.m_21561_(this.mob.m_5448_() != null && !this.mob.isBurrowed());
            return super.m_8036_() && this.mob.f_19853_.m_46791_() != Difficulty.PEACEFUL && !this.mob.isBurrowed();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.mob.f_19853_.m_46791_() != Difficulty.PEACEFUL && !this.mob.isBurrowed();
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(this.mob.m_5448_() != null);
        }
    }

    static class BurrowGoal
    extends Goal {
        private final GluttonEntity mob;
        private int tick = 0;
        private ItemStack cacheitem = ItemStack.f_41583_;

        public BurrowGoal(GluttonEntity entityIn) {
            this.mob = entityIn;
        }

        public boolean m_8036_() {
            return !this.mob.m_5912_() && this.mob.isSuitable(this.mob, null);
        }

        public boolean m_8045_() {
            return !this.mob.m_5912_() && this.mob.isSuitable(this.mob, null);
        }

        public void m_8056_() {
            this.mob.setBurrowed(true);
        }

        public void m_8041_() {
            this.tick = 0;
            this.mob.setBurrowed(false);
        }

        public void m_8037_() {
            Vec3 vec3d = this.mob.directionVector().m_82490_(0.6);
            AABB boundingBox = this.mob.m_142469_().m_82369_(vec3d).m_82369_(vec3d.m_82490_(-1.0));
            List entities = this.mob.f_19853_.m_45933_((Entity)this.mob, boundingBox);
            if (!(entities.isEmpty() || this.mob.m_5912_() || this.mob.isEnchanting())) {
                for (Entity entity : entities) {
                    if (!boundingBox.m_82390_(entity.m_20182_())) continue;
                    if (entity instanceof ItemEntity) {
                        ItemStack item = ((ItemEntity)entity).m_32055_();
                        if (((ItemEntity)entity).m_32057_() == this.mob.m_142081_()) continue;
                        this.cacheitem = item.m_41777_();
                        this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), (SoundEvent)ModSounds.GLUTTON_EAT.get(), this.mob.m_5720_(), 0.8f, 0.9f);
                        entity.m_146870_();
                        this.mob.setEnchanting(true);
                        break;
                    }
                    if (!(entity instanceof LivingEntity) || !entity.m_6084_() || !this.mob.m_6779_((LivingEntity)entity) || this.mob.m_5912_()) continue;
                    this.mob.setBurrowed(false);
                    this.mob.m_21561_(true);
                    this.mob.m_7327_(entity);
                }
            }
            if (this.mob.isEnchanting()) {
                ++this.tick;
                if (this.tick % 16 == 0) {
                    MutablePair<Integer, ItemStack> pair = this.mob.modifyEnchantments(this.cacheitem, this.cacheitem.m_41773_(), 1);
                    ItemStack item = (ItemStack)pair.getRight();
                    if (this.cacheitem.m_41720_().equals(ModItems.VOID_HEART.get())) {
                        Explosion.BlockInteraction explosion$mode = this.mob.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                        this.mob.f_19853_.m_46511_((Entity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 2.0f, explosion$mode);
                        this.mob.m_146870_();
                    }
                    if ((Integer)pair.getLeft() == 0) {
                        if (item != ItemStack.f_41583_) {
                            this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_11871_, this.mob.m_5720_(), 0.8f, 0.6f);
                        }
                    } else if ((Integer)pair.getLeft() == 1) {
                        this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), (SoundEvent)ModSounds.GLUTTON_SPIT.get(), this.mob.m_5720_(), 0.8f, 0.8f);
                        newitem = new ItemEntity(this.mob.f_19853_, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.cacheitem);
                        newitem.m_32052_(this.mob.m_142081_());
                        this.mob.f_19853_.m_7967_((Entity)newitem);
                    } else {
                        this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12275_, this.mob.m_5720_(), 0.8f, 0.6f);
                        item.m_41784_().m_128405_("Bitten", 1);
                        newitem = new ItemEntity(this.mob.f_19853_, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), item);
                        newitem.m_32052_(this.mob.m_142081_());
                        this.mob.f_19853_.m_7967_((Entity)newitem);
                    }
                    this.cacheitem = ItemStack.f_41583_;
                    this.tick = 0;
                    this.mob.setEnchanting(false);
                }
            }
        }
    }

    static class FindSpotGoal
    extends Goal {
        protected final GluttonEntity mob;
        private double spotX;
        private double spotY;
        private double spotZ;
        private final double movementSpeed;

        public FindSpotGoal(GluttonEntity theCreatureIn, double movementSpeedIn) {
            this.mob = theCreatureIn;
            this.movementSpeed = movementSpeedIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.isPossibleSpot() && this.mob.m_5448_() == null && !this.mob.isBurrowed() && !this.mob.isSuitable(this.mob, null);
        }

        protected boolean isPossibleSpot() {
            Vec3 vector3d = this.findPossibleSpot();
            if (vector3d == null) {
                return false;
            }
            this.spotX = vector3d.f_82479_;
            this.spotY = vector3d.f_82480_;
            this.spotZ = vector3d.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_() && !this.mob.isBurrowed();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.spotX, this.spotY, this.spotZ, this.movementSpeed);
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
        }

        @Nullable
        protected Vec3 findPossibleSpot() {
            Random random = this.mob.m_21187_();
            BlockPos blockpos = this.mob.m_142538_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_142082_(random.nextInt(20) - 10, random.nextInt(3) - 1, random.nextInt(20) - 10);
                if (!this.mob.isSuitable(this.mob, blockpos1) || !(this.mob.m_21692_(blockpos1) < 0.0f)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    static class WanderGoal
    extends WaterAvoidingRandomStrollGoal {
        private final GluttonEntity mob;

        public WanderGoal(GluttonEntity entityIn) {
            super((PathfinderMob)entityIn, 1.0, 0.1f);
            this.mob = entityIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isBurrowed() && !this.mob.isSuitable(this.mob, null);
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isBurrowed() && !this.mob.isSuitable(this.mob, null);
        }

        public void m_8037_() {
            if (this.mob.isBurrowed() || this.mob.isSuitable(this.mob, null)) {
                this.mob.m_21573_().m_26573_();
            }
        }
    }

    static class LookGoal
    extends RandomLookAroundGoal {
        private final GluttonEntity mob;

        public LookGoal(GluttonEntity entitylivingIn) {
            super((Mob)entitylivingIn);
            this.mob = entitylivingIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isBurrowed();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isBurrowed();
        }
    }
}

