/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.entity;

import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.entity.HealthUtil;
import io.github.how_bout_no.outvoted.entity.WildfireFireballEntity;
import io.github.how_bout_no.outvoted.init.ModSounds;
import io.github.how_bout_no.outvoted.item.WildfireHelmetItem;
import io.github.how_bout_no.outvoted.util.IMixinBlazeEntity;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildfireEntity
extends Monster
implements IAnimatable {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private boolean shieldDisabled = false;
    private static final EntityDataAccessor<Boolean> SHIELDING = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> ON_FIRE = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WildfireEntity(EntityType<? extends WildfireEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 20;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, 0.115).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        HealthUtil.setConfigHealth((LivingEntity)this, Outvoted.commonConfig.entities.wildfire.health);
        int type = 0;
        if (reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.DISPENSER) {
            if (worldIn.m_45837_(this.m_142538_()).isPresent() && worldIn.m_45837_(this.m_142538_()).get() == Biomes.f_48199_) {
                type = 1;
            }
        } else {
            Block block = worldIn.m_8055_(this.m_20099_()).m_60734_();
            if (block == Blocks.f_50135_ || block == Blocks.f_50136_) {
                type = 1;
            }
        }
        this.setVariant(type);
        if (reason == MobSpawnType.NATURAL) {
            ServerLevel serverWorld = worldIn.m_6018_();
            int max = switch (difficultyIn.m_19048_()) {
                case Difficulty.NORMAL -> 3;
                case Difficulty.HARD -> 4;
                default -> 2;
            };
            int min = max - 1;
            int rand = new Random().nextInt(max - min) + min;
            for (int i = 1; i <= rand; ++i) {
                Blaze blaze = (Blaze)EntityType.f_20551_.m_20615_((Level)serverWorld);
                blaze.m_19890_(this.m_20208_(3.0), this.m_20186_(), this.m_20262_(3.0), this.m_146908_(), this.m_146909_());
                while (!serverWorld.m_46859_(blaze.m_142538_())) {
                    blaze.m_19890_(this.m_20208_(3.0), this.m_20186_(), this.m_20262_(3.0), this.m_146908_(), this.m_146909_());
                }
                ((IMixinBlazeEntity)blaze).m_6518_(worldIn, difficultyIn, reason, null, null);
                serverWorld.m_7967_((Entity)blaze);
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    protected Component m_5677_() {
        return this.getVariant() == 0 ? super.m_5677_() : new TranslatableComponent("entity.outvoted.wildfire_s");
    }

    public int m_5792_() {
        return this.f_19853_.m_46791_() == Difficulty.HARD ? 2 : 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELDING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ATTACKING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ON_FIRE, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void setShielding(boolean shielding) {
        if (!this.shieldDisabled) {
            this.f_19804_.m_135381_(SHIELDING, (Object)shielding);
        } else {
            this.f_19804_.m_135381_(SHIELDING, (Object)false);
        }
    }

    public boolean getShielding() {
        return (Boolean)this.f_19804_.m_135370_(SHIELDING) != false && !this.shieldDisabled;
    }

    public void setVariant(int type) {
        this.f_19804_.m_135381_(VARIANT, (Object)type);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void m_21561_(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean getIsAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WILDFIRE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WILDFIRE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.WILDFIRE_HURT.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.8f;
    }

    public float m_6073_() {
        return 1.0f;
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.nextInt(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, (SoundEvent)ModSounds.WILDFIRE_BURN.get(), this.m_5720_(), 1.0f + this.f_19796_.nextFloat(), this.f_19796_.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.getShielding()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.getIsAttacking()) {
            for (int particlei = 0; particlei < 16; ++particlei) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        if (stack.m_41720_() instanceof WildfireHelmetItem && !this.f_19853_.m_5776_() && this.getVariant() == 1) {
            stack.m_41784_().m_128350_("SoulTexture", 1.0f);
        }
        return super.m_5552_(stack, yOffset);
    }

    protected void m_8024_() {
        LivingEntity livingentity;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.f_19796_.nextGaussian() * (3.0f / (this.m_21223_() / 25.0f + 1.0f));
        }
        if ((livingentity = this.m_5448_()) != null && livingentity.m_20188_() > this.m_20188_() + (double)this.heightOffset && this.m_6779_(livingentity)) {
            Vec3 vector3d = this.m_20184_();
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vector3d.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        super.m_8024_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_6060_() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return ((Byte)this.f_19804_.m_135370_(ON_FIRE) & 1) != 0;
    }

    public void m_146868_(boolean onFire) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ON_FIRE);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(ON_FIRE, (Object)b0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_) {
            Entity entity = source.m_7640_();
            if (entity instanceof LivingEntity) {
                double itemDamage;
                LivingEntity entity2 = (LivingEntity)entity;
                if (this.m_20147_() && entity2.m_21205_().m_41720_() instanceof AxeItem && (double)amount >= (itemDamage = (double)(((AxeItem)entity2.m_21205_().m_41720_()).m_41008_() + 1.0f)) + itemDamage / 2.0) {
                    this.m_5496_(SoundEvents.f_11669_, 0.3f, 1.5f);
                    this.shieldDisabled = true;
                    this.setShielding(false);
                    this.m_20331_(false);
                    return false;
                }
            }
            if (this.m_6673_(source)) {
                this.m_5496_(SoundEvents.f_11669_, 0.3f, 0.5f);
                if (source.m_7640_() != null) {
                    if (source.m_19360_()) {
                        source.m_7640_().m_20254_(12);
                    } else {
                        source.m_7640_().m_20254_(8);
                    }
                }
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6673_(DamageSource source) {
        if ((source == DamageSource.f_19318_ || source instanceof EntityDamageSource) && !source.m_19390_()) {
            return this.m_20147_();
        }
        return false;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        String animname;
        String string = animname = event.getController().getCurrentAnimation() != null ? event.getController().getCurrentAnimation().animationName : "";
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) || !animname.equals("attack")) {
            if (this.getIsAttacking()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("attack"));
            } else if (this.getShielding()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("shieldtransition").addAnimation("shielding"));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("generaltransition").addAnimation("general"));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class AttackGoal
    extends Goal {
        private final WildfireEntity mob;
        private int attackStep;
        private int attackTime;
        private int firedRecentlyTimer;

        public AttackGoal(WildfireEntity wildfireIn) {
            this.mob = wildfireIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.mob.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.mob.m_146868_(false);
            this.mob.setShielding(false);
            this.mob.m_21561_(false);
            this.firedRecentlyTimer = 0;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.mob.m_5448_();
            this.mob.m_21561_(false);
            if (livingentity != null) {
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                this.firedRecentlyTimer = flag ? 0 : ++this.firedRecentlyTimer;
                double d0 = this.mob.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    this.mob.m_146868_(true);
                    if (this.attackTime <= 0) {
                        this.mob.m_21561_(true);
                        this.attackTime = 5;
                        this.mob.m_7327_((Entity)livingentity);
                        livingentity.m_20254_(4);
                    }
                    this.mob.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    float health = (this.mob.m_21233_() - this.mob.m_21223_()) / 2.0f;
                    float healthPercent = this.mob.m_21223_() / this.mob.m_21233_();
                    int maxAttackSteps = 3;
                    if (d0 < 36.0) {
                        ++maxAttackSteps;
                    }
                    if ((double)healthPercent < 0.6) {
                        ++maxAttackSteps;
                    }
                    if (this.attackTime <= 0) {
                        this.mob.setShielding(false);
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = (int)(40.0f * healthPercent + 20.0f);
                            this.mob.m_146868_(true);
                        } else if (this.attackStep <= maxAttackSteps) {
                            this.attackTime = (int)(25.0f * healthPercent + 5.0f);
                        } else {
                            this.attackTime = 200;
                            this.attackStep = 0;
                            this.mob.m_146868_(false);
                            this.mob.m_21561_(false);
                        }
                        if (this.attackStep > 1) {
                            this.mob.m_21561_(true);
                            if (!this.mob.m_20067_()) {
                                this.mob.f_19853_.m_5594_(null, this.mob.m_142538_(), (SoundEvent)ModSounds.WILDFIRE_SHOOT.get(), this.mob.m_5720_(), 1.0f, 1.0f);
                            }
                            double fireballcount = Outvoted.commonConfig.entities.wildfire.attacking.fireballCount;
                            double offsetangle = Math.toRadians(Outvoted.commonConfig.entities.wildfire.attacking.offsetAngle);
                            double maxdepressangle = Math.toRadians(Outvoted.commonConfig.entities.wildfire.attacking.maxDepressAngle);
                            double d1 = livingentity.m_20185_() - this.mob.m_20185_();
                            double d2 = livingentity.m_20227_(0.5) - this.mob.m_20227_(0.5);
                            double d3 = livingentity.m_20189_() - this.mob.m_20189_();
                            int i = 0;
                            while ((double)i <= fireballcount - 1.0) {
                                double angle = ((double)i - (fireballcount - 1.0) / 2.0) * offsetangle;
                                double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                                double y = d2;
                                double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                                double a = Math.sqrt(d1 * d1 + d3 * d3);
                                if (Math.abs(Math.atan2(d2, a)) > maxdepressangle) {
                                    y = -Math.tan(maxdepressangle) * a;
                                }
                                WildfireFireballEntity wildfirefireballentity = new WildfireFireballEntity(this.mob.f_19853_, (LivingEntity)this.mob, x, y, z);
                                wildfirefireballentity.m_6034_(wildfirefireballentity.m_20185_(), this.mob.m_20227_(0.5), wildfirefireballentity.m_20189_());
                                this.mob.f_19853_.m_7967_((Entity)wildfirefireballentity);
                                ++i;
                            }
                        }
                    } else if ((float)this.attackTime < 160.0f + health && (float)this.attackTime > 90.0f - health) {
                        this.mob.setShielding(true);
                    } else if (this.attackTime >= 30 && this.attackTime >= 50) {
                        this.mob.setShielding(false);
                        this.mob.shieldDisabled = false;
                    }
                    this.mob.m_20331_(this.mob.getShielding());
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.firedRecentlyTimer < 5) {
                    this.mob.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.mob.m_21133_(Attributes.f_22277_);
        }
    }
}

