/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.forge.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class Blocks
extends BlockModelProvider {
    private static String type = "";
    private static String textureBase = "";

    public Blocks(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "outvoted", existingFileHelper);
    }

    protected void registerModels() {
        this.buttonModel("copper_button", new ResourceLocation("block/copper_block"));
        this.buttonModel("exposed_copper_button", new ResourceLocation("block/exposed_copper"));
        this.buttonModel("weathered_copper_button", new ResourceLocation("block/weathered_copper"));
        this.buttonModel("oxidized_copper_button", new ResourceLocation("block/oxidized_copper"));
        this.buttonModel("waxed_copper_button", new ResourceLocation("block/copper_block"));
        this.buttonModel("waxed_exposed_copper_button", new ResourceLocation("block/exposed_copper"));
        this.buttonModel("waxed_weathered_copper_button", new ResourceLocation("block/weathered_copper"));
        this.buttonModel("waxed_oxidized_copper_button", new ResourceLocation("block/oxidized_copper"));
    }

    private void registerWood(String input) {
        type = input;
        textureBase = "block/" + type;
        this.buttonModel();
        this.doorModel();
        this.fenceGateModel();
        this.fenceModel();
        this.singleTexture(type + "_leaves", new ResourceLocation("block/leaves"), "all", this.id("_leaves"));
        this.cubeColumn(type + "_log", this.id("_log"), this.id("_log_top"));
        this.cubeAll(type + "_planks", this.id("_planks"));
        this.pressurePlateModel();
        this.slabModel();
        this.stairsModel();
        this.trapdoorModel();
        this.cubeColumn(type + "_wood", this.id("_log"), this.id("_log"));
        this.strippedModels();
    }

    private ResourceLocation id(String suffix) {
        return new ResourceLocation("outvoted", textureBase + suffix);
    }

    private void buttonModel() {
        this.buttonModel(type + "_button", new ResourceLocation("outvoted", textureBase + "_planks"));
    }

    private void buttonModel(String path, ResourceLocation texture) {
        this.singleTexture(path, new ResourceLocation("block/button"), "texture", texture);
        this.singleTexture(path + "_inventory", new ResourceLocation("block/button_inventory"), "texture", texture);
        this.singleTexture(path + "_pressed", new ResourceLocation("block/button_pressed"), "texture", texture);
    }

    private void doorModel() {
        String path = type + "_door";
        ResourceLocation bottom = new ResourceLocation("outvoted", textureBase + "_door_bottom");
        ResourceLocation top = new ResourceLocation("outvoted", textureBase + "_door_top");
        this.doorTopLeft(path + "_top", bottom, top);
        this.doorTopRight(path + "_top_hinge", bottom, top);
        this.doorBottomLeft(path + "_bottom", bottom, top);
        this.doorBottomRight(path + "_bottom_hinge", bottom, top);
    }

    private void fenceGateModel() {
        String path = type + "_fence_gate";
        ResourceLocation texture = new ResourceLocation("outvoted", textureBase + "_planks");
        this.fenceGate(path, texture);
        this.fenceGateOpen(path + "_open", texture);
        this.fenceGateWall(path + "_wall", texture);
        this.fenceGateWallOpen(path + "_wall_open", texture);
    }

    private void fenceModel() {
        String path = type + "_fence";
        ResourceLocation texture = new ResourceLocation("outvoted", textureBase + "_planks");
        this.fenceInventory(path + "_inventory", texture);
        this.fencePost(path + "_post", texture);
        this.fenceSide(path + "_side", texture);
    }

    private void pressurePlateModel() {
        String path = type + "_pressure_plate";
        ResourceLocation texture = new ResourceLocation("outvoted", textureBase + "_planks");
        this.singleTexture(path, new ResourceLocation("block/pressure_plate_up"), "texture", texture);
        this.singleTexture(path + "_down", new ResourceLocation("block/pressure_plate_down"), "texture", texture);
    }

    private void slabModel() {
        String path = type + "_slab";
        ResourceLocation texture = new ResourceLocation("outvoted", textureBase + "_planks");
        this.slab(path, texture, texture, texture);
        this.slabTop(path + "_top", texture, texture, texture);
    }

    private void stairsModel() {
        String path = type + "_stairs";
        ResourceLocation texture = new ResourceLocation("outvoted", textureBase + "_planks");
        this.stairs(path, texture, texture, texture);
        this.stairsInner(path + "_inner", texture, texture, texture);
        this.stairsOuter(path + "_outer", texture, texture, texture);
    }

    private void trapdoorModel() {
        String path = type + "_trapdoor";
        ResourceLocation texture = new ResourceLocation("outvoted", textureBase + "_trapdoor");
        this.trapdoorBottom(path + "_bottom", texture);
        this.trapdoorOpen(path + "_open", texture);
        this.trapdoorTop(path + "_top", texture);
    }

    private void strippedModels() {
        String path = "stripped_" + type;
        String newTextureBase = "block/" + path;
        this.cubeColumn(path + "_log", new ResourceLocation("outvoted", newTextureBase + "_log"), new ResourceLocation("outvoted", newTextureBase + "_log_top"));
        this.cubeColumnHorizontal(path + "_log_horizontal", new ResourceLocation("outvoted", newTextureBase + "_log"), new ResourceLocation("outvoted", newTextureBase + "_log_top"));
        this.cubeColumn(path + "_wood", new ResourceLocation("outvoted", newTextureBase + "_log"), new ResourceLocation("outvoted", newTextureBase + "_log"));
    }
}

