/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.forge.data;

import io.github.how_bout_no.outvoted.init.ModItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class Items
extends ItemModelProvider {
    private static String type = "";

    public Items(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "outvoted", existingFileHelper);
    }

    protected void registerModels() {
        this.generated("book");
        this.generated((Item)ModItems.WILDFIRE_SHIELD_PART.get());
        this.generated((Item)ModItems.WILDFIRE_PIECE.get());
        this.generated((Item)ModItems.VOID_HEART.get());
        this.generated((Item)ModItems.BARNACLE_TOOTH.get());
        this.generated((Item)ModItems.PRISMARINE_ROD.get());
        this.egg((Item)ModItems.WILDFIRE_SPAWN_EGG.get());
        this.egg((Item)ModItems.GLUTTON_SPAWN_EGG.get());
        this.egg((Item)ModItems.BARNACLE_SPAWN_EGG.get());
        this.egg((Item)ModItems.GLARE_SPAWN_EGG.get());
        this.withExistingParent("copper_button", new ResourceLocation("outvoted", "block/copper_button_inventory"));
        this.withExistingParent("exposed_copper_button", new ResourceLocation("outvoted", "block/exposed_copper_button_inventory"));
        this.withExistingParent("weathered_copper_button", new ResourceLocation("outvoted", "block/weathered_copper_button_inventory"));
        this.withExistingParent("oxidized_copper_button", new ResourceLocation("outvoted", "block/oxidized_copper_button_inventory"));
        this.withExistingParent("waxed_copper_button", new ResourceLocation("outvoted", "block/waxed_copper_button_inventory"));
        this.withExistingParent("waxed_exposed_copper_button", new ResourceLocation("outvoted", "block/waxed_exposed_copper_button_inventory"));
        this.withExistingParent("waxed_weathered_copper_button", new ResourceLocation("outvoted", "block/waxed_weathered_copper_button_inventory"));
        this.withExistingParent("waxed_oxidized_copper_button", new ResourceLocation("outvoted", "block/waxed_oxidized_copper_button_inventory"));
        ((ItemModelBuilder)this.singleTexture(((Item)ModItems.WILDFIRE_HELMET.get()).getRegistryName().m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("outvoted", "item/wildfire_helmet"))).override().predicate(new ResourceLocation("outvoted", "soul_texture"), 1.0f).model(new ModelFile(new ResourceLocation("outvoted", "item/wildfire_helmet_soul")){

            protected boolean exists() {
                return true;
            }
        });
        this.generated(((Item)ModItems.WILDFIRE_HELMET.get()).getRegistryName().m_135815_() + "_soul");
        ((ItemModelBuilder)this.singleTexture(((Item)ModItems.WILDFIRE_SHIELD.get()).getRegistryName().m_135815_(), new ResourceLocation("item/shield"), "particles", new ResourceLocation("block/nether_bricks"))).override().predicate(new ResourceLocation("blocking"), 1.0f).model(new ModelFile(new ResourceLocation("outvoted", "item/wildfire_shield_blocking")){

            protected boolean exists() {
                return true;
            }
        });
        this.singleTexture(((Item)ModItems.WILDFIRE_SHIELD.get()).getRegistryName().m_135815_() + "_blocking", new ResourceLocation("item/shield_blocking"), "particles", new ResourceLocation("block/nether_bricks"));
    }

    private void generated(String path) {
        this.singleTexture(path, new ResourceLocation("item/generated"), "layer0", new ResourceLocation("outvoted", "item/" + path));
    }

    private void generated(Item item) {
        this.generated(item.getRegistryName().m_135815_());
    }

    private void egg(Item item) {
        this.withExistingParent(item.getRegistryName().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
    }

    private void registerWood(String input) {
        type = input;
        this.withParent("button", "inventory");
        this.generatedWood("door");
        this.withParent("fence", "inventory");
        this.withParent("fence_gate");
        this.withParent("leaves");
        this.withParent("log");
        this.withParent("planks");
        this.withParent("pressure_plate");
        this.generatedWood("sapling", "block/" + type + "_sapling");
        this.generatedWood("sign");
        this.withParent("slab");
        this.withParent("stairs");
        this.withParent("trapdoor", "bottom");
        this.withParent("wood");
        this.withExistingParent("stripped_" + type + "_log", new ResourceLocation("outvoted", "block/stripped_" + type + "_log"));
        this.withExistingParent("stripped_" + type + "_wood", new ResourceLocation("outvoted", "block/stripped_" + type + "_wood"));
    }

    private void generatedWood(String suffix) {
        suffix = "_" + (String)suffix;
        this.singleTexture(type + (String)suffix, new ResourceLocation("item/generated"), "layer0", new ResourceLocation("outvoted", "item/" + type + (String)suffix));
    }

    private void generatedWood(String suffix, String texture) {
        suffix = "_" + (String)suffix;
        this.singleTexture(type + (String)suffix, new ResourceLocation("item/generated"), "layer0", new ResourceLocation("outvoted", texture));
    }

    private void withParent(String suffix) {
        suffix = "_" + (String)suffix;
        this.withExistingParent(type + (String)suffix, new ResourceLocation("outvoted", "block/" + type + (String)suffix));
    }

    private void withParent(String suffix, String suffix2) {
        suffix = "_" + (String)suffix;
        suffix2 = "_" + (String)suffix2;
        this.withExistingParent(type + (String)suffix, new ResourceLocation("outvoted", "block/" + type + (String)suffix + (String)suffix2));
    }
}

