/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.item;

import io.github.how_bout_no.outvoted.Outvoted;
import io.github.how_bout_no.outvoted.item.ModArmor;
import io.github.how_bout_no.outvoted.util.GroupCheck;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildfireHelmetItem
extends ArmorItem
implements IAnimatable {
    private int timer = 0;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WildfireHelmetItem() {
        super((ArmorMaterial)ModArmor.WILDFIRE, EquipmentSlot.HEAD, new Item.Properties().m_41486_().m_41491_(Outvoted.TAB_COMBAT));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (slot == EquipmentSlot.HEAD.m_20749_()) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int helmetPenalty = Outvoted.commonConfig.misc.helmetPenalty;
            if (helmetPenalty != 0) {
                if (livingEntity.m_6060_()) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1, 0, false, false, true));
                    if (this.timer % helmetPenalty == 0) {
                        stack.m_41622_(1 + this.timer / 600, livingEntity, consumer -> consumer.m_21166_(EquipmentSlot.HEAD));
                    }
                    ++this.timer;
                } else {
                    this.timer = 0;
                }
            } else {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1, 0, false, false, true));
            }
        }
    }

    protected boolean m_41389_(CreativeModeTab group) {
        return GroupCheck.isIn(group, Outvoted.TAB_COMBAT);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.m_41389_(group)) {
            stacks.add((Object)new ItemStack((ItemLike)this));
            if (Outvoted.config.client.wildfireVariants) {
                ItemStack soul = new ItemStack((ItemLike)this);
                soul.m_41784_().m_128350_("SoulTexture", 1.0f);
                stacks.add((Object)soul);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (stack != null && this.isSoul(stack)) {
            return new TranslatableComponent("item.outvoted.wildfire_helmet_s");
        }
        return super.m_7626_(stack);
    }

    private boolean isSoul(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128457_("SoulTexture") == 1.0f;
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

