/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.mixin;

import io.github.how_bout_no.outvoted.entity.CopperGolemEntity;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningRodBlock.class})
public abstract class MixinLightningRodBlock
extends RodBlock {
    @Nullable
    private BlockPattern copperGolemPattern;
    private static final Predicate<BlockState> IS_GOLEM_HEAD_PREDICATE = state -> state != null && (state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_));
    private static final Predicate<BlockState> IS_GOLEM_BODY_PREDICATE = state -> state != null && (state.m_60713_(Blocks.f_152504_) || state.m_60713_(Blocks.f_152502_) || state.m_60713_(Blocks.f_152503_) || state.m_60713_(Blocks.f_152501_));

    protected MixinLightningRodBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"onBlockAdded"}, at={@At(value="HEAD")})
    public void trySpawn(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.trySpawnEntity(world, pos);
        }
    }

    private void trySpawnEntity(Level world, BlockPos pos) {
        BlockPattern.BlockPatternMatch result = this.getCopperGolemPattern().m_61184_((LevelReader)world, pos);
        if (result != null) {
            BlockState head = result.m_61229_(0, 1, 0).m_61168_();
            BlockState body = result.m_61229_(0, 2, 0).m_61168_();
            for (int i = 0; i < this.getCopperGolemPattern().m_61202_(); ++i) {
                BlockInWorld cachedBlockPosition = result.m_61229_(0, i, 0);
                world.m_7731_(cachedBlockPosition.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                world.m_46796_(2001, cachedBlockPosition.m_61176_(), Block.m_49956_((BlockState)cachedBlockPosition.m_61168_()));
            }
            CopperGolemEntity entity = (CopperGolemEntity)((EntityType)ModEntityTypes.COPPER_GOLEM.get()).m_20615_(world);
            BlockPos blockPos = result.m_61229_(0, 2, 0).m_61176_();
            entity.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, ((Direction)head.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_() - 360.0f, entity.m_146909_());
            entity.f_20883_ = entity.f_20885_ = ((Direction)head.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_() - 360.0f;
            entity.m_19915_(((Direction)head.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_() - 360.0f, entity.m_146909_());
            entity.setRotations(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((Direction)head.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_() - 360.0f});
            world.m_7967_((Entity)entity);
            entity.setOxidizationLevel(((WeatheringCopperFullBlock)body.m_60734_()).m_142297_().ordinal());
            for (ServerPlayer serverPlayerEntity : world.m_45976_(ServerPlayer.class, entity.m_142469_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverPlayerEntity, (Entity)entity);
            }
            for (int j = 0; j < 3; ++j) {
                BlockInWorld cachedBlockPosition2 = result.m_61229_(0, j, 0);
                world.m_6289_(cachedBlockPosition2.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    private BlockPattern getCopperGolemPattern() {
        if (this.copperGolemPattern == null) {
            this.copperGolemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"!", "^", "#"}).m_61244_('!', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_152587_))).m_61244_('^', BlockInWorld.m_61169_(IS_GOLEM_HEAD_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_(IS_GOLEM_BODY_PREDICATE)).m_61249_();
        }
        return this.copperGolemPattern;
    }
}

