/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.world;

import io.github.how_bout_no.outvoted.entity.BarnacleEntity;
import io.github.how_bout_no.outvoted.entity.CopperGolemEntity;
import io.github.how_bout_no.outvoted.entity.GlareEntity;
import io.github.how_bout_no.outvoted.entity.GluttonEntity;
import io.github.how_bout_no.outvoted.init.ModEntityTypes;
import io.github.how_bout_no.outvoted.mixin.SpawnRestrictionAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.levelgen.Heightmap;

public class SpawnUtil {
    public static boolean isBelowCap(MobCategory group, ServerLevel world, int multiplier) {
        ChunkMap chunkStorage = world.m_7726_().f_8325_;
        int scc = chunkStorage.m_143145_().m_140816_();
        NaturalSpawner.SpawnState info = new NaturalSpawner.SpawnState(scc, new Object2IntOpenHashMap(), new PotentialCalculator());
        int i = group.m_21608_() * scc / NaturalSpawner.f_46978_;
        return info.m_47148_().getInt((Object)group) < i * Math.max(multiplier, 1);
    }

    public static void registerRestrictions() {
        SpawnRestrictionAccessor.callRegister((EntityType)ModEntityTypes.WILDFIRE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnRestrictionAccessor.callRegister((EntityType)ModEntityTypes.GLUTTON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GluttonEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((EntityType)ModEntityTypes.BARNACLE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING, BarnacleEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((EntityType)ModEntityTypes.GLARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GlareEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((EntityType)ModEntityTypes.COPPER_GOLEM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, CopperGolemEntity::canSpawn);
    }
}

