/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.scuba_gear;

import com.google.common.collect.ImmutableList;
import com.legacy.scuba_gear.ScubaConfig;
import com.legacy.scuba_gear.ScubaRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScubaEvents {
    private static final List<Item> SCUBA_GEAR = ImmutableList.of((Object)ScubaRegistry.SCUBA_HELMET, (Object)ScubaRegistry.SCUBA_CHESTPLATE, (Object)ScubaRegistry.SCUBA_LEGGINGS, (Object)ScubaRegistry.SCUBA_BOOTS);
    private static final AttributeModifier HELMET_SPEED_MODIFIER = new AttributeModifier("scuba helmet land speed reduction", (double)-0.003f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_SPEED_MODIFIER = new AttributeModifier("scuba chestplate land speed reduction", (double)-0.005f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SPEED_MODIFIER = new AttributeModifier("scuba leggings land speed reduction", (double)-0.002f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_SPEED_MODIFIER = new AttributeModifier("scuba boots land speed reduction", (double)-0.001f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SWIM_SPEED_MODIFIER = new AttributeModifier("scuba swim speed addition", (double)0.3f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier UNDERWATER_WALK_SPEED_MODIFIER = new AttributeModifier("scuba underwater walk speed addition", (double)0.8f, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (event.getEntity() instanceof Drowned && ScubaEvents.isRuinOrWreckNearby(event.getEntity())) {
            float chance = entity.f_19853_.f_46441_.nextFloat();
            if (chance < 0.5f) {
                event.getEntity().m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ScubaRegistry.SCUBA_HELMET));
            }
            if (chance < 0.4f) {
                event.getEntity().m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ScubaRegistry.SCUBA_BOOTS));
            }
            if (chance < 0.3f) {
                event.getEntity().m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ScubaRegistry.SCUBA_LEGGINGS));
            }
            if (chance < 0.2f) {
                event.getEntity().m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ScubaRegistry.SCUBA_CHESTPLATE));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().m_19384_() && ScubaEvents.isWearingFullScuba(event.getEntityLiving())) {
            event.getEntityLiving().m_7311_(0);
            event.setCanceled(true);
            event.getEntityLiving().m_6168_().forEach(armor -> {
                if (event.getEntityLiving() instanceof ServerPlayer && event.getEntityLiving().f_19797_ % 10 == 0 && !event.getEntityLiving().f_19853_.f_46443_) {
                    armor.m_41622_(1, event.getEntityLiving(), living -> {});
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof Player || living instanceof Drowned) {
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) && !living.m_20072_(), Attributes.f_22279_, HELMET_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST) && !living.m_20072_(), Attributes.f_22279_, CHESTPLATE_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS) && !living.m_20072_(), Attributes.f_22279_, LEGGINGS_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET) && !living.m_20072_(), Attributes.f_22279_, BOOTS_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, living.m_6067_() && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS), (Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, !living.m_6069_() && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET), (Attribute)ForgeMod.SWIM_SPEED.get(), UNDERWATER_WALK_SPEED_MODIFIER);
            if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) && living.m_19941_((Tag)FluidTags.f_13131_) && !living.f_19853_.f_46443_) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 5, 0, false, false, false));
            }
            if (living instanceof Player && living.m_20072_() && !living.f_19853_.f_46443_ && living.f_19797_ % 80 == 0) {
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD)) {
                    living.m_6844_(EquipmentSlot.HEAD).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.HEAD));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST)) {
                    living.m_6844_(EquipmentSlot.CHEST).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.CHEST));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS)) {
                    living.m_6844_(EquipmentSlot.LEGS).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.LEGS));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET)) {
                    living.m_6844_(EquipmentSlot.FEET).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.FEET));
                }
            }
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (ScubaEvents.isWearingScubaOnSlot(event.getEntityLiving(), EquipmentSlot.CHEST) && event.getEntityLiving().m_19941_((Tag)FluidTags.f_13131_) && !event.getEntityLiving().m_21023_(MobEffects.f_19599_)) {
            event.setNewSpeed(event.getOriginalSpeed() + 0.7f);
        }
    }

    public static boolean isWearingScuba(LivingEntity living) {
        return ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET);
    }

    public static boolean isWearingFullScuba(LivingEntity living) {
        return ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET);
    }

    public static boolean isWearingScubaOnSlot(LivingEntity living, EquipmentSlot pieceValue) {
        return SCUBA_GEAR.contains(living.m_6844_(pieceValue).m_41720_());
    }

    private static void checkAddAndRemoveModifier(LivingEntity living, boolean condition, Attribute attribute, AttributeModifier modifier) {
        if (condition) {
            if (!living.m_21051_(attribute).m_22109_(modifier)) {
                living.m_21051_(attribute).m_22118_(modifier);
            }
        } else {
            ScubaEvents.removeModifier(living, attribute, modifier);
        }
    }

    private static void removeModifier(LivingEntity living, Attribute attribute, AttributeModifier modifier) {
        if (living.m_21051_(attribute).m_22109_(modifier)) {
            living.m_21051_(attribute).m_22130_(modifier);
        }
    }

    private static boolean isRuinOrWreckNearby(Entity entity) {
        BlockPos pos = entity.m_142538_();
        Level world = entity.f_19853_;
        if (world instanceof ServerLevel && ((ServerLevel)world).m_8595_().m_47285_(pos, true, StructureFeature.f_67024_).m_73603_()) {
            return true;
        }
        int radius = ScubaConfig.COMMON.getMaxDistanceFromRuin();
        BlockPos min = pos.m_142082_(-radius, -radius, -radius);
        BlockPos max = pos.m_142082_(radius, radius, radius);
        for (BlockPos posAround : BlockPos.MutableBlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (!(world instanceof ServerLevel) || !((ServerLevel)world).m_8595_().m_47285_(posAround, true, StructureFeature.f_67024_).m_73603_()) continue;
            return true;
        }
        return false;
    }
}

