/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.scuba_gear.client;

import com.legacy.scuba_gear.ScubaGearMod;
import com.legacy.scuba_gear.client.ScubaBootsModel;
import com.legacy.scuba_gear.client.ScubaChestplateModel;
import com.legacy.scuba_gear.client.ScubaHelmetModel;
import com.legacy.scuba_gear.client.ScubaLeggingsModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ScubaLayers {
    public static final ModelLayerLocation SCUBA_HELMET = ScubaLayers.layer("scuba_helmet");
    public static final ModelLayerLocation SCUBA_CHESTPLATE = ScubaLayers.layer("scuba_chestplate");
    public static final ModelLayerLocation SCUBA_LEGGINGS = ScubaLayers.layer("scuba_leggings");
    public static final ModelLayerLocation SCUBA_BOOTS = ScubaLayers.layer("scuba_boots");
    public static ScubaHelmetModel<LivingEntity> helmetModel = null;
    public static ScubaChestplateModel<LivingEntity> chestplateModel = null;
    public static ScubaLeggingsModel<LivingEntity> leggingsModel = null;
    public static ScubaBootsModel<LivingEntity> bootModel = null;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ScubaLayers::initLayers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ScubaLayers::initModels);
    }

    public static void initPost(FMLClientSetupEvent event) {
    }

    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SCUBA_HELMET, () -> ScubaHelmetModel.createHelmetLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(SCUBA_CHESTPLATE, () -> ScubaChestplateModel.createChestplateLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(SCUBA_LEGGINGS, () -> ScubaLeggingsModel.createLeggingsLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(SCUBA_BOOTS, () -> ScubaBootsModel.createBootsLayer(CubeDeformation.f_171458_));
    }

    public static void initModels(EntityRenderersEvent.AddLayers event) {
        helmetModel = new ScubaHelmetModel(ScubaLayers.getModel().m_171103_(SCUBA_HELMET));
        chestplateModel = new ScubaChestplateModel(ScubaLayers.getModel().m_171103_(SCUBA_CHESTPLATE));
        leggingsModel = new ScubaLeggingsModel(ScubaLayers.getModel().m_171103_(SCUBA_LEGGINGS));
        bootModel = new ScubaBootsModel(ScubaLayers.getModel().m_171103_(SCUBA_BOOTS));
    }

    private static ModelLayerLocation layer(String name) {
        return ScubaLayers.layer(name, "main");
    }

    private static ModelLayerLocation layer(String name, String layer) {
        return new ModelLayerLocation(ScubaGearMod.locate(name), layer);
    }

    private static EntityModelSet getModel() {
        return Minecraft.m_91087_().m_167973_();
    }
}

