/*
 * Decompiled with CFR 0.152.
 */
package io.github.jvcmarcenes.skbakpacks;

import io.github.jvcmarcenes.skbakpacks.BackpackContainer;
import io.github.jvcmarcenes.skbakpacks.BackpackInventory;
import io.github.jvcmarcenes.skbakpacks.BackpackProvider;
import io.github.jvcmarcenes.skbakpacks.Backpacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BackpackItem
extends Item {
    public static BackpackInventory getInventory(ItemStack stack) {
        IItemHandler inventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (inventory == null || !(inventory instanceof BackpackInventory)) {
            throw new RuntimeException("Error trying to load backpack inventory");
        }
        return (BackpackInventory)inventory;
    }

    public BackpackItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            MenuProvider menuProvider = new MenuProvider(){

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
                    return new BackpackContainer(windowId, playerInv, BackpackItem.getInventory(stack), stack);
                }

                public Component m_5446_() {
                    return new TranslatableComponent(((Item)Backpacks.BACKPACK.get()).m_5524_());
                }
            };
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuProvider);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new BackpackProvider();
    }

    public CompoundTag getShareTag(ItemStack stack) {
        BackpackInventory inv;
        CompoundTag capTag;
        CompoundTag combTag = new CompoundTag();
        CompoundTag baseTag = stack.m_41783_();
        if (baseTag != null) {
            combTag.m_128365_("base", (Tag)baseTag);
        }
        if ((capTag = (inv = BackpackItem.getInventory(stack)).serializeNBT()) != null) {
            combTag.m_128365_("cap", (Tag)capTag);
        }
        return combTag;
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_(null);
            return;
        }
        CompoundTag baseTag = nbt.m_128469_("base");
        stack.m_41751_(baseTag);
        CompoundTag capTag = nbt.m_128469_("cap");
        BackpackInventory inv = BackpackItem.getInventory(stack);
        inv.deserializeNBT(capTag);
    }
}

