/*
 * Decompiled with CFR 0.152.
 */
package io.github.jvcmarcenes.skbakpacks;

import io.github.jvcmarcenes.skbakpacks.BackpackInventory;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BackpackProvider
implements ICapabilitySerializable<Tag> {
    private BackpackInventory inventory;
    private final LazyOptional<IItemHandler> lazyInventory = LazyOptional.of(this::getCachedInventory);

    private BackpackInventory getCachedInventory() {
        if (this.inventory == null) {
            this.inventory = new BackpackInventory();
        }
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyInventory;
        }
        return LazyOptional.empty();
    }

    public Tag serializeNBT() {
        ListTag tagList = new ListTag();
        BackpackInventory inv = this.getCachedInventory();
        int size = inv.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("slot", i);
            stack.m_41739_(itemTag);
            tagList.add((Object)itemTag);
        }
        return tagList;
    }

    public void deserializeNBT(Tag nbt) {
        ListTag tagList = (ListTag)nbt;
        this.inventory = new BackpackInventory();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = (CompoundTag)tagList.get(i);
            int slot = itemTag.m_128451_("slot");
            if (slot < 0 || slot >= this.inventory.getSlots()) continue;
            this.inventory.setStackInSlot(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
    }
}

