/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.PickupHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class ItemEntityEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack)) {
            String command;
            CarryOnOverride override;
            player.getPersistentData().m_128473_("carrySlot");
            event.setUseBlock(Event.Result.DENY);
            if (!player.f_19853_.f_46443_ && (override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandPlace()) != null) {
                player.m_20194_().m_129892_().m_82117_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + command);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        ItemEntity eitem;
        ItemStack stack;
        Item item;
        Entity e = event.getEntity();
        Level world = event.getWorld();
        Entity entity = e;
        if (entity instanceof ItemEntity && (item = (stack = (eitem = (ItemEntity)entity).m_32055_()).m_41720_()) == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack)) {
            BlockPos pos = eitem.m_142538_();
            Entity entity2 = ItemCarryonEntity.getEntity(stack, world);
            entity2.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_(entity2);
            ItemCarryonEntity.clearEntityData(stack);
            eitem.m_32045_(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ItemStack main = player.m_21205_();
            ItemStack off = player.m_21206_();
            Level world = event.getWorld();
            Entity entity = event.getTarget();
            BlockPos pos = entity.m_142538_();
            if (main.m_41619_() && off.m_41619_() && CarryOnKeybinds.isKeyPressed(player)) {
                ItemStack stack = new ItemStack((ItemLike)RegistrationHandler.itemEntity);
                if (entity.f_19802_ == 0) {
                    if (entity instanceof Animal) {
                        ((Animal)entity).m_21455_(true, true);
                    }
                    if (PickupHandler.canPlayerPickUpEntity((ServerPlayer)player, entity) && ItemCarryonEntity.storeEntityData(entity, world, stack)) {
                        LazyOptional handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                        handler.ifPresent(hand -> {
                            for (int i = 0; i < hand.getSlots(); ++i) {
                                hand.extractItem(i, 64, false);
                            }
                        });
                        CarryOnOverride override = ScriptChecker.inspectEntity(entity);
                        int overrideHash = 0;
                        if (override != null) {
                            overrideHash = override.hashCode();
                        }
                        ItemEvents.sendPacket(player, player.m_150109_().f_35977_, overrideHash);
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).m_21153_(0.0f);
                        }
                        entity.m_20153_();
                        entity.m_6034_(entity.m_20185_(), 0.0, entity.m_20189_());
                        entity.m_146870_();
                        player.m_21008_(InteractionHand.MAIN_HAND, stack);
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.FAIL);
                    }
                }
            } else if (!main.m_41619_() && main.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(main) && !CarryOnKeybinds.isKeyPressed(player) && ((Boolean)Configs.Settings.stackableEntities.get()).booleanValue()) {
                Entity entityHeld = ItemCarryonEntity.getEntity(main, world);
                if (entity.f_19802_ == 0 && entityHeld instanceof LivingEntity && !world.f_46443_ && entityHeld.m_142081_() != entity.m_142081_() && entity.m_6084_()) {
                    double sizeHeldEntity = entityHeld.m_20206_() * entityHeld.m_20205_();
                    double distance = pos.m_123331_((Vec3i)player.m_142538_());
                    Entity lowestEntity = entity.m_20201_();
                    int numPassengers = ItemEntityEvents.getAllPassengers(lowestEntity);
                    if (numPassengers < (Integer)Configs.Settings.maxEntityStackLimit.get() - 1) {
                        Entity topEntity = ItemEntityEvents.getTopPassenger(lowestEntity);
                        if ((Boolean)Configs.Settings.useWhitelistStacking.get() != false ? ListHandler.isStackingAllowed(topEntity) : !ListHandler.isStackingForbidden(topEntity)) {
                            double sizeEntity = topEntity.m_20206_() * topEntity.m_20205_();
                            if ((Boolean)Configs.Settings.entitySizeMattersStacking.get() != false && sizeHeldEntity <= sizeEntity || !((Boolean)Configs.Settings.entitySizeMattersStacking.get()).booleanValue()) {
                                Entity entity2 = topEntity;
                                if (entity2 instanceof Horse) {
                                    Horse horse = (Horse)entity2;
                                    horse.m_30651_(true);
                                }
                                if (distance < 6.0) {
                                    double tempX = entity.m_20185_();
                                    double tempY = entity.m_20186_();
                                    double tempZ = entity.m_20189_();
                                    entityHeld.m_6034_(tempX, tempY + 2.6, tempZ);
                                    world.m_7967_(entityHeld);
                                    entityHeld.m_7998_(topEntity, false);
                                    entityHeld.m_6021_(tempX, tempY, tempZ);
                                } else {
                                    entityHeld.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                                    world.m_7967_(entityHeld);
                                    entityHeld.m_7998_(topEntity, false);
                                }
                                ItemCarryonEntity.clearEntityData(main);
                                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                                ItemEvents.sendPacket(player, 9, 0);
                                event.setCanceled(true);
                                event.setCancellationResult(InteractionResult.FAIL);
                                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12034_, SoundSource.PLAYERS, 0.5f, 1.5f);
                            } else {
                                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12209_, SoundSource.PLAYERS, 0.5f, 1.5f);
                            }
                        }
                    } else {
                        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12209_, SoundSource.PLAYERS, 0.5f, 1.5f);
                    }
                }
            }
        }
    }

    public static int getAllPassengers(Entity entity) {
        int passengers = 0;
        while (entity.m_20160_()) {
            List pass = entity.m_20197_();
            if (pass.isEmpty()) continue;
            entity = (Entity)pass.get(0);
            ++passengers;
        }
        return passengers;
    }

    public static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.m_20160_()) {
            List pass = entity.m_20197_();
            if (pass.isEmpty()) continue;
            top = entity = (Entity)pass.get(0);
        }
        return top;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level world = entity.f_19853_;
        ItemStack main = entity.m_21205_();
        if (!main.m_41619_() && main.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(main)) {
            Entity contained;
            BlockPos pos = entity.m_142538_();
            BlockPos below = pos.m_142300_(Direction.DOWN);
            if ((world.m_8055_(pos).m_60767_() == Material.f_76305_ || world.m_8055_(below).m_60767_() == Material.f_76305_) && (contained = ItemCarryonEntity.getEntity(main, world)) != null) {
                float height = contained.m_20205_();
                float width = contained.m_20205_();
                entity.m_5997_(0.0, -0.01 * (double)height * (double)width, 0.0);
            }
        }
    }
}

