/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.PickupHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.common.scripting.ScriptReader;
import tschipp.carryon.network.client.CarrySlotPacket;
import tschipp.carryon.network.client.ScriptReloadPacket;

@Mod.EventBusSubscriber(modid="carryon")
public class ItemEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (!stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack)) {
            String command;
            CarryOnOverride override;
            player.getPersistentData().m_128473_("carrySlot");
            event.setUseBlock(Event.Result.DENY);
            if (!player.f_19853_.f_46443_ && (override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandPlace()) != null && !command.isEmpty()) {
                player.m_20194_().m_129892_().m_82117_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + command);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        ItemEntity eitem;
        ItemStack stack;
        Item item;
        Entity e = event.getEntity();
        Level world = event.getWorld();
        Entity entity = e;
        if (entity instanceof ItemEntity && (item = (stack = (eitem = (ItemEntity)entity).m_32055_()).m_41720_()) == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack)) {
            BlockPos pos;
            BlockPos finalPos = pos = eitem.m_142538_();
            DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, Direction.DOWN, stack, Direction.UP);
            if (!world.m_8055_(pos).m_60629_((BlockPlaceContext)context) || !context.m_7059_()) {
                for (Direction facing : Direction.values()) {
                    BlockPos offsetPos = pos.m_142300_(facing);
                    DirectionalPlaceContext newContext = new DirectionalPlaceContext(world, offsetPos, Direction.DOWN, stack, Direction.UP);
                    if (!world.m_8055_(offsetPos).m_60629_((BlockPlaceContext)newContext) || !newContext.m_7059_()) continue;
                    finalPos = offsetPos;
                    break;
                }
            }
            world.m_46597_(finalPos, ItemCarryonBlock.getBlockState(stack));
            BlockEntity tile = world.m_7702_(finalPos);
            if (tile != null) {
                CompoundTag nbt = ItemCarryonBlock.getTileData(stack);
                ItemCarryonBlock.updateTileLocation(nbt, finalPos);
                tile.m_142466_(nbt);
            }
            ItemCarryonBlock.clearTileData(stack);
            eitem.m_32045_(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = event.getPlayer();
            Level world = player.m_20193_();
            ItemStack carried = player.m_21205_();
            if (!carried.m_41619_() && carried.m_41720_() == RegistrationHandler.itemTile || carried.m_41720_() == RegistrationHandler.itemEntity) {
                if (carried.m_41720_() == RegistrationHandler.itemTile) {
                    CarryOnOverride override = ScriptChecker.inspectBlock(ItemCarryonBlock.getBlockState(carried), world, player.m_142538_(), ItemCarryonBlock.getTileData(carried));
                    if (override != null) {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_(), override.hashCode()));
                    } else {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_()));
                    }
                } else {
                    CarryOnOverride override = ScriptChecker.inspectEntity(ItemCarryonEntity.getEntity(carried, world));
                    if (override != null) {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_(), override.hashCode()));
                    } else {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_()));
                    }
                }
            }
        }
        if (event.getPlayer() instanceof ServerPlayer) {
            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new ScriptReloadPacket(ScriptReader.OVERRIDES.values()));
        }
    }

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        CommandCarryOn.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        CustomPickupOverrideHandler.initPickupOverrides();
    }

    @SubscribeEvent
    public void reloadTags(TagsUpdatedEvent event) {
        ListHandler.initConfigLists();
    }

    @SubscribeEvent
    public void onEntityStartTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        Player tracker = event.getPlayer();
        Entity entity = e;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (tracker instanceof ServerPlayer) {
                Level world = player.m_20193_();
                ItemStack carried = player.m_21205_();
                if (!carried.m_41619_() && carried.m_41720_() == RegistrationHandler.itemTile || carried.m_41720_() == RegistrationHandler.itemEntity) {
                    if (carried.m_41720_() == RegistrationHandler.itemTile) {
                        CarryOnOverride override = ScriptChecker.inspectBlock(ItemCarryonBlock.getBlockState(carried), world, player.m_142538_(), ItemCarryonBlock.getTileData(carried));
                        if (override != null) {
                            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)tracker), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_(), override.hashCode()));
                        } else {
                            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)tracker), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_()));
                        }
                    } else {
                        CarryOnOverride override = ScriptChecker.inspectEntity(ItemCarryonEntity.getEntity(carried, world));
                        if (override != null) {
                            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)tracker), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_(), override.hashCode()));
                        } else {
                            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)tracker), (Object)new CarrySlotPacket(player.m_150109_().f_35977_, player.m_142049_()));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void harvestSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        Player player = event.getPlayer();
        if (!(player == null || ((Boolean)Configs.Settings.hitWhileCarrying.get()).booleanValue() || (stack = player.m_21205_()).m_41619_() || stack.m_41720_() != RegistrationHandler.itemTile && stack.m_41720_() != RegistrationHandler.itemEntity)) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41619_() || ((Boolean)Configs.Settings.hitWhileCarrying.get()).booleanValue() || stack.m_41720_() != RegistrationHandler.itemTile && stack.m_41720_() != RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void harvestSpeed(BlockEvent.BreakEvent event) {
        ItemStack stack;
        Player player = event.getPlayer();
        if (!(player == null || ((Boolean)Configs.Settings.hitWhileCarrying.get()).booleanValue() || (stack = player.m_21205_()).m_41619_() || stack.m_41720_() != RegistrationHandler.itemTile && stack.m_41720_() != RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerAttack(LivingAttackEvent event) {
        LivingEntity eliving = event.getEntityLiving();
        LivingEntity livingEntity = eliving;
        if (livingEntity instanceof Player) {
            ItemStack stack;
            Player player = (Player)livingEntity;
            if (!(!((Boolean)Configs.Settings.dropCarriedWhenHit.get()).booleanValue() || (stack = player.m_21205_()).m_41619_() || stack.m_41720_() != RegistrationHandler.itemTile && stack.m_41720_() != RegistrationHandler.itemEntity || player.f_19853_.f_46443_)) {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                ItemEntity item = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                ItemEvents.sendPacket(player, 9, 0);
                player.f_19853_.m_7967_((Entity)item);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (event.isCanceled()) {
            return;
        }
        if (!player.f_19853_.f_46443_) {
            ItemStack main = player.m_21205_();
            ItemStack off = player.m_21206_();
            Level world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = world.m_8055_(pos);
            if (main.m_41619_() && off.m_41619_() && CarryOnKeybinds.isKeyPressed(player)) {
                ItemStack stack = new ItemStack((ItemLike)RegistrationHandler.itemTile);
                BlockEntity te = world.m_7702_(pos);
                if (PickupHandler.canPlayerPickUpBlock((ServerPlayer)player, te, world, pos)) {
                    player.m_6915_();
                    world.m_46796_(1010, pos, 0);
                    if (ItemCarryonBlock.storeTileData(te, world, pos, state, stack)) {
                        String command;
                        BlockState statee = world.m_8055_(pos);
                        CompoundTag tag = new CompoundTag();
                        tag = world.m_7702_(pos) != null ? world.m_7702_(pos).m_6945_(tag) : new CompoundTag();
                        CarryOnOverride override = ScriptChecker.inspectBlock(state, world, pos, tag);
                        int overrideHash = 0;
                        if (override != null) {
                            overrideHash = override.hashCode();
                        }
                        boolean success = false;
                        try {
                            ItemEvents.sendPacket(player, player.m_150109_().f_35977_, overrideHash);
                            world.m_46747_(pos);
                            world.m_7471_(pos, false);
                            player.m_21008_(InteractionHand.MAIN_HAND, stack);
                            event.setUseBlock(Event.Result.DENY);
                            event.setUseItem(Event.Result.DENY);
                            event.setCanceled(true);
                            success = true;
                        }
                        catch (Exception e) {
                            try {
                                ItemEvents.sendPacket(player, player.m_150109_().f_35977_, overrideHash);
                                ItemEvents.emptyTileEntity(te);
                                world.m_7471_(pos, false);
                                player.m_21008_(InteractionHand.MAIN_HAND, stack);
                                event.setUseBlock(Event.Result.DENY);
                                event.setUseItem(Event.Result.DENY);
                                event.setCanceled(true);
                                success = true;
                            }
                            catch (Exception ex) {
                                ItemEvents.sendPacket(player, 9, 0);
                                world.m_46597_(pos, statee);
                                if (!tag.m_128456_()) {
                                    BlockEntity.m_155241_((BlockPos)pos, (BlockState)statee, (CompoundTag)tag);
                                }
                                player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Error detected. Cannot pick up block."), false);
                                TextComponent s = new TextComponent(ChatFormatting.GOLD + "here");
                                s.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                                player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Please report this error ").m_7220_((Component)s), false);
                            }
                        }
                        if (success && override != null && (command = override.getCommandInit()) != null) {
                            player.m_20194_().m_129892_().m_82117_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + command);
                        }
                    }
                }
            }
        }
    }

    public static void emptyTileEntity(BlockEntity te) {
        if (te != null) {
            for (Direction facing : Direction.values()) {
                LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                itemHandler.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        handler.extractItem(i, 64, false);
                    }
                });
            }
            LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            itemHandler.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    handler.extractItem(i, 64, false);
                }
            });
            BlockEntity blockEntity = te;
            if (blockEntity instanceof Container) {
                Container inv = (Container)blockEntity;
                inv.m_6211_();
            }
            if ((blockEntity = te) instanceof IItemHandler) {
                IItemHandler itemHandler1 = (IItemHandler)blockEntity;
                for (int i = 0; i < itemHandler1.getSlots(); ++i) {
                    itemHandler1.extractItem(i, 64, false);
                }
            }
            te.m_6596_();
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        boolean wasCarrying;
        Player original = event.getOriginal();
        Player player = event.getPlayer();
        boolean wasDead = event.isWasDeath();
        GameRules rules = player.f_19853_.m_46469_();
        boolean keepInv = rules.m_46207_(GameRules.f_46133_);
        boolean bl = wasCarrying = player.m_150109_().m_36063_(new ItemStack((ItemLike)RegistrationHandler.itemTile)) || player.m_150109_().m_36063_(new ItemStack((ItemLike)RegistrationHandler.itemEntity));
        if ((!wasDead || keepInv) && wasCarrying) {
            int carrySlot = original.m_150109_().f_35977_;
            ItemStack stack = player.m_150109_().m_8016_(carrySlot);
            Level world = player.f_19853_;
            ItemEntity item = new ItemEntity(world, 0.0, 0.0, 0.0, stack);
            BlockPos pos = null;
            Optional bedpos = original.m_21257_();
            if (bedpos.isPresent()) {
                pos = (BlockPos)bedpos.get();
            }
            if (pos == null) {
                pos = player.m_142538_();
            }
            item.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            world.m_7967_((Entity)item);
        }
    }

    @SubscribeEvent
    public void dropNonHotbarItems(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        LivingEntity livingEntity = entity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!entity.f_19853_.f_46443_) {
                String command;
                CarryOnOverride override;
                boolean hasCarried = player.m_150109_().m_36063_(new ItemStack((ItemLike)RegistrationHandler.itemTile)) || player.m_150109_().m_36063_(new ItemStack((ItemLike)RegistrationHandler.itemEntity));
                ItemStack inHand = player.m_21205_();
                if (hasCarried && inHand.m_41720_() != RegistrationHandler.itemTile && inHand.m_41720_() != RegistrationHandler.itemEntity && player.m_6045_() == 0) {
                    ItemStack dropped;
                    int slotBlock = this.getSlot(player, RegistrationHandler.itemTile);
                    int slotEntity = this.getSlot(player, RegistrationHandler.itemEntity);
                    ItemEntity item = null;
                    if (slotBlock != -1) {
                        dropped = player.m_150109_().m_8016_(slotBlock);
                        item = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), dropped);
                    }
                    if (slotEntity != -1) {
                        dropped = player.m_150109_().m_8016_(slotEntity);
                        item = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), dropped);
                    }
                    if (item != null) {
                        player.f_19853_.m_7967_(item);
                        ItemEvents.sendPacket(player, 9, 0);
                    }
                }
                if ((override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandLoop()) != null) {
                    player.m_20194_().m_129892_().m_82117_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + command);
                }
            }
        }
    }

    public int getSlot(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    public static void sendPacket(Player player, int currentItem, int hash) {
        if (player instanceof ServerPlayer) {
            CarryOn.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 128.0, player.f_19853_.m_46472_())), (Object)new CarrySlotPacket(currentItem, player.m_142049_(), hash));
            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CarrySlotPacket(currentItem, player.m_142049_(), hash));
            if (currentItem >= 9) {
                player.getPersistentData().m_128473_("carrySlot");
                player.getPersistentData().m_128473_("overrideKey");
            } else {
                player.getPersistentData().m_128405_("carrySlot", currentItem);
                if (hash != 0) {
                    ScriptChecker.setCarryOnOverride(player, hash);
                }
            }
        }
    }
}

