/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import com.google.common.base.CharMatcher;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;

public class ItemCarryonBlock
extends Item {
    public static final String TILE_DATA_KEY = "tileData";
    public static final String[] FACING_KEYS = new String[]{"rotation", "rot", "facing", "face", "direction", "dir", "front", "forward"};

    public ItemCarryonBlock() {
        super(new Item.Properties().m_41487_(1));
        this.setRegistryName("carryon", "tile_item");
    }

    public Component m_7626_(ItemStack stack) {
        if (ItemCarryonBlock.hasTileData(stack)) {
            CompoundTag nbt;
            BlockState state = ItemCarryonBlock.getBlockState(stack);
            if (ModelOverridesHandler.hasCustomOverrideModel(state, nbt = ItemCarryonBlock.getTileData(stack))) {
                Object override = ModelOverridesHandler.getOverrideObject(state, nbt);
                if (override instanceof ItemStack) {
                    return ((ItemStack)override).m_41786_();
                }
                BlockState ostate = (BlockState)override;
                return ostate.m_60734_().m_49954_();
            }
            return ItemCarryonBlock.getItemStack(stack).m_41786_();
        }
        return new TextComponent("");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        block18: {
            Direction facing = context.m_43719_();
            Player player = context.m_43723_();
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            ItemStack stack = context.m_43722_();
            if (ModList.get().isLoaded("betterplacement") && CarryOnKeybinds.isKeyPressed(player)) {
                return InteractionResult.FAIL;
            }
            if (ItemCarryonBlock.hasTileData(stack)) {
                try {
                    boolean canPlace;
                    Vec3 vec = player.m_20154_();
                    Direction facing2 = Direction.m_122372_((float)((float)vec.f_82479_), (float)0.0f, (float)((float)vec.f_82481_));
                    BlockPos pos2 = pos;
                    Block containedblock = ItemCarryonBlock.getBlock(stack);
                    BlockState containedstate = ItemCarryonBlock.getBlockState(stack);
                    if (!world.m_8055_(pos2).m_60629_(new BlockPlaceContext(context))) {
                        pos2 = pos.m_142300_(facing);
                    }
                    if (world.m_8055_(pos2).m_60629_(new BlockPlaceContext(context)) && containedblock != null && (canPlace = containedstate.m_60710_((LevelReader)world, pos2)) && player.m_36204_(pos, facing, stack) && world.m_7966_(player, pos2)) {
                        BlockState placementState = containedblock.m_5573_(new BlockPlaceContext(context));
                        BlockState actualState = placementState == null ? containedstate : placementState;
                        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos2);
                        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snapshot, world.m_8055_(pos), (Entity)player);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.isCanceled()) {
                            BlockEntity tile;
                            world.m_46597_(pos2, actualState);
                            if (!ItemCarryonBlock.getTileData(stack).m_128456_()) {
                                CompoundTag tag = ItemCarryonBlock.getTileData(stack);
                                Set keys = tag.m_128431_();
                                block7: for (String key : keys) {
                                    for (String facingKey : FACING_KEYS) {
                                        if (!key.toLowerCase().equals(facingKey)) continue;
                                        byte type = tag.m_128435_(key);
                                        switch (type) {
                                            case 8: {
                                                tag.m_128359_(key, CharMatcher.javaUpperCase().matchesAllOf((CharSequence)tag.m_128461_(key)) ? facing2.m_122424_().m_122433_().toUpperCase() : facing2.m_122424_().m_122433_());
                                                break;
                                            }
                                            case 3: {
                                                tag.m_128405_(key, facing2.m_122424_().m_122411_());
                                                break;
                                            }
                                            case 1: {
                                                tag.m_128344_(key, (byte)facing2.m_122424_().m_122411_());
                                                break;
                                            }
                                        }
                                        break block7;
                                    }
                                }
                            }
                            if ((tile = world.m_7702_(pos2)) != null) {
                                CompoundTag data = ItemCarryonBlock.getTileData(stack);
                                ItemCarryonBlock.updateTileLocation(data, pos2);
                                tile.m_142466_(data);
                            }
                            ItemCarryonBlock.clearTileData(stack);
                            player.m_5496_(actualState.getSoundType((LevelReader)world, pos2, (Entity)player).m_56777_(), 1.0f, 0.5f);
                            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                            player.getPersistentData().m_128473_("overrideKey");
                            ItemEvents.sendPacket(player, 9, 0);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (world == null || !world.f_46443_) break block18;
                    CarryOn.LOGGER.info("Block: " + ItemCarryonBlock.getBlock(stack));
                    CarryOn.LOGGER.info("BlockState: " + ItemCarryonBlock.getBlockState(stack));
                    CarryOn.LOGGER.info("ItemStack: " + ItemCarryonBlock.getItemStack(stack));
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemCarryonBlock.getBlockState(stack), ItemCarryonBlock.getTileData(stack))) {
                        CarryOn.LOGGER.info("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemCarryonBlock.getBlockState(stack), ItemCarryonBlock.getTileData(stack)));
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonBlock.getBlockState(stack))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonBlock.getBlockState(stack)));
                    }
                    player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Error detected. Cannot place block. Execute \"/carryon clear\" to remove the item"), false);
                    TextComponent s = new TextComponent(ChatFormatting.GOLD + "here");
                    s.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                    player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Please report this error ").m_7220_((Component)s), false);
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemCarryonBlock.hasTileData(stack)) {
            if (entity instanceof LivingEntity) {
                if (!(entity instanceof Player && ((Boolean)Configs.Settings.slownessInCreative.get()).booleanValue() || !((Player)entity).m_7500_())) {
                    return;
                }
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 1, this.potionLevel(stack), false, false));
            }
        } else {
            stack = ItemStack.f_41583_;
        }
    }

    public static boolean hasTileData(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128441_(TILE_DATA_KEY) && tag.m_128441_("block") && tag.m_128441_("stateid");
        }
        return false;
    }

    public static boolean storeTileData(@Nullable BlockEntity tile, Level world, BlockPos pos, BlockState state, ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41619_()) {
            return false;
        }
        CompoundTag tileTag = new CompoundTag();
        if (tile != null) {
            tileTag = tile.m_6945_(tileTag);
        }
        CompoundTag compoundTag = tag = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        if (tag.m_128441_(TILE_DATA_KEY)) {
            return false;
        }
        tag.m_128365_(TILE_DATA_KEY, (Tag)tileTag);
        tag.m_128359_("block", state.m_60734_().getRegistryName().toString());
        tag.m_128405_("stateid", Block.m_49956_((BlockState)state));
        stack.m_41751_(tag);
        return true;
    }

    public static void updateTileLocation(CompoundTag tag, BlockPos pos) {
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
    }

    public static void clearTileData(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            tag.m_128473_(TILE_DATA_KEY);
            tag.m_128473_("block");
            tag.m_128473_("stateid");
        }
    }

    public static CompoundTag getTileData(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128469_(TILE_DATA_KEY);
        }
        return null;
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            int id = tag.m_128451_("stateid");
            return Block.m_49803_((int)id).m_60734_();
        }
        return Blocks.f_50016_;
    }

    public static ItemStack getItemStack(ItemStack stack) {
        return new ItemStack((ItemLike)ItemCarryonBlock.getBlock(stack), 1);
    }

    public static BlockState getBlockState(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            int id = tag.m_128451_("stateid");
            return Block.m_49803_((int)id);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static boolean isLocked(BlockPos pos, Level world) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            CompoundTag tag = new CompoundTag();
            te.m_6945_(tag);
            return tag.m_128441_("Lock") ? !tag.m_128461_("Lock").equals("") : false;
        }
        return false;
    }

    private int potionLevel(ItemStack stack) {
        String nbt = ItemCarryonBlock.getTileData(stack).toString();
        int i = nbt.length() / 500;
        if (i > 4) {
            i = 4;
        }
        if (!((Boolean)Configs.Settings.heavyTiles.get()).booleanValue()) {
            i = 1;
        }
        return (int)((double)i * (Double)Configs.Settings.blockSlownessMultiplier.get());
    }
}

