/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptReader;
import tschipp.carryon.network.client.ScriptReloadPacket;

@Mod.EventBusSubscriber(modid="carryon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScriptReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ScriptReloadListener() {
        super(GSON, "carryon/scripts");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager manager, ProfilerFiller profiler) {
        ScriptReader.OVERRIDES.clear();
        objects.forEach((path, jsonElem) -> {
            CarryOnOverride override = new CarryOnOverride((JsonElement)jsonElem, (ResourceLocation)path);
            if (!override.isInvalid) {
                ScriptReader.OVERRIDES.put(override.hashCode(), override);
            }
        });
        if (EffectiveSide.get().isServer() && ServerLifecycleHooks.getCurrentServer() != null) {
            CarryOn.network.send(PacketDistributor.ALL.noArg(), (Object)new ScriptReloadPacket(ScriptReader.OVERRIDES.values()));
        }
    }

    @SubscribeEvent
    public static void onDatapackRegister(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ScriptReloadListener());
    }
}

