/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.ai;

import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;

public class AIMultipleTargetGoal<T extends LivingEntity>
extends Goal {
    protected final Mob goalOwner;
    protected final Class<T> targetClass;
    protected List<T> nearestTargets;
    protected final boolean shouldCheckSight;
    protected int unseenMemoryTicks = 60;
    private int targetUnseenTicks;

    public <A extends Mob> AIMultipleTargetGoal(A goalOwnerIn, Class<T> targetClassIn) {
        this(goalOwnerIn, targetClassIn, false);
    }

    public <A extends Mob> AIMultipleTargetGoal(A goalOwnerIn, Class<T> targetClassIn, boolean checkSight) {
        this.goalOwner = goalOwnerIn;
        this.shouldCheckSight = checkSight;
        this.targetClass = targetClassIn;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        this.findNearestTarget();
        return !this.nearestTargets.isEmpty();
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.goalOwner instanceof IMultiTargetEntity) {
            IMultiTargetEntity multiTargeter = (IMultiTargetEntity)this.goalOwner;
            multiTargeter.setAttackTargets(new ArrayList<LivingEntity>(this.nearestTargets));
        }
    }

    public boolean m_8045_() {
        boolean shouldContinue = false;
        if (this.goalOwner instanceof IMultiTargetEntity) {
            IMultiTargetEntity multiTargeter = (IMultiTargetEntity)this.goalOwner;
            for (LivingEntity livingentity : multiTargeter.getAttackTargets()) {
                if (livingentity == null || !livingentity.m_6084_()) continue;
                Team team = this.goalOwner.m_5647_();
                Team team1 = livingentity.m_5647_();
                if (team != null && team1 == team) continue;
                double d0 = this.getTargetDistance();
                if (this.goalOwner.m_20280_((Entity)livingentity) > d0 * d0) continue;
                if (this.shouldCheckSight) {
                    if (this.goalOwner.m_21574_().m_148306_((Entity)livingentity)) {
                        this.targetUnseenTicks = 0;
                    } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) continue;
                }
                if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) continue;
                shouldContinue = true;
            }
        }
        return shouldContinue;
    }

    public void m_8041_() {
        if (this.goalOwner instanceof IMultiTargetEntity) {
            IMultiTargetEntity multiTargeter = (IMultiTargetEntity)this.goalOwner;
            multiTargeter.setAttackTargets(new ArrayList<LivingEntity>());
        }
        this.nearestTargets.clear();
    }

    protected void findNearestTarget() {
        this.nearestTargets = this.goalOwner.f_19853_.m_6443_(this.targetClass, this.getTargetableArea(this.getTargetDistance()), EntitySelector.f_20406_);
    }

    protected double getTargetDistance() {
        return this.goalOwner.m_21133_(Attributes.f_22277_);
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.goalOwner.m_142469_().m_82377_(targetDistance, targetDistance / 2.0, targetDistance);
    }
}

