/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.block;

import com.dainxt.dungeonsmod.block.BlockBase;
import com.dainxt.dungeonsmod.tileentity.WardshiperBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;

public class WardshiperBlock
extends BlockBase
implements EntityBlock {
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.f_61387_;

    public WardshiperBlock(String name) {
        super(name, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60955_().m_60918_(SoundType.f_56736_).m_60977_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PROPERTY_STAGE});
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        BlockEntity te;
        super.m_7458_(state, worldIn, pos, rand);
        if (!worldIn.f_46443_ && (te = worldIn.m_7702_(pos)) instanceof WardshiperBlockEntity && WardshiperBlock.isTotemBuilded((Level)worldIn, pos)) {
            if ((Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0) {
                List leashes = worldIn.m_45976_(LeashFenceKnotEntity.class, new AABB(pos).m_82377_(1.0, 0.0, 1.0));
                List nearMobs = worldIn.m_45976_(Mob.class, new AABB(pos).m_82377_(7.0, 7.0, 7.0));
                Optional<Mob> target2 = nearMobs.stream().filter(nearMob -> nearMob.m_142538_().equals((Object)pos.m_7494_())).findAny();
                if (target2.isPresent() && target2.get() != null) {
                    nearMobs.removeIf(leashedMob -> !leashes.contains(leashedMob.m_21524_()));
                    double resultHealth = 0.0;
                    if (nearMobs.size() == 4) {
                        resultHealth = nearMobs.stream().mapToDouble(sacrifice -> sacrifice.m_21223_()).sum();
                    }
                    resultHealth /= 2.0;
                    if ((double)target2.get().m_21233_() <= resultHealth) {
                        ((WardshiperBlockEntity)te).setTarget(target2.get().m_6095_());
                        ((WardshiperBlockEntity)te).setUsesLeft(1000);
                        worldIn.m_151523_(te);
                        nearMobs.forEach(sacrifice -> sacrifice.m_6469_(DamageSource.f_19319_, sacrifice.m_21233_()));
                        target2.get().m_6469_(DamageSource.f_19319_, target2.get().m_21233_());
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)));
                    }
                }
            } else if (((WardshiperBlockEntity)te).getUsesLeft() > 0) {
                List nearMobs = worldIn.m_45976_(Mob.class, new AABB(pos).m_82377_(16.0, 16.0, 16.0));
                nearMobs.forEach(target -> {
                    if (target.m_6095_() == ((WardshiperBlockEntity)te).getTarget()) {
                        target.m_6469_(DamageSource.f_19319_, target.m_21233_());
                        ((WardshiperBlockEntity)te).setUsesLeft(((WardshiperBlockEntity)te).getUsesLeft() - 1);
                    }
                });
            }
            if (((WardshiperBlockEntity)te).getUsesLeft() <= 0) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState p_152433_, Entity entityIn) {
        super.m_141947_(worldIn, pos, p_152433_, entityIn);
        if (!worldIn.f_46443_ && WardshiperBlock.isTotemBuilded(worldIn, pos) && entityIn instanceof LivingEntity) {
            BlockState state = worldIn.m_8055_(pos);
            if (entityIn.f_19797_ % 20 == 0 && (Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0) {
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)ParticleTypes.f_123746_, entityIn.m_20185_(), entityIn.m_20186_() - 0.5, entityIn.m_20189_(), 8, (worldIn.f_46441_.nextDouble() - 0.5) * 2.0, -worldIn.f_46441_.nextDouble(), (worldIn.f_46441_.nextDouble() - 0.5) * 2.0, (double)0.05f);
            }
        }
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        super.m_7100_(stateIn, worldIn, pos, rand);
        if ((Integer)stateIn.m_61143_((Property)PROPERTY_STAGE) == 1) {
            for (int i = 0; i < 2; ++i) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, (worldIn.f_46441_.nextDouble() - 0.5) * 8.0, -worldIn.f_46441_.nextDouble(), (worldIn.f_46441_.nextDouble() - 0.5) * 8.0);
            }
        }
    }

    public static boolean isTotemBuilded(Level world, BlockPos pos) {
        boolean isBuilded = true;
        isBuilded = world.m_8055_(pos.m_142127_()).m_60734_().equals(Blocks.f_50662_) && isBuilded;
        isBuilded = world.m_8055_(pos.m_142128_()).m_60734_().equals(Blocks.f_50662_) && isBuilded;
        isBuilded = world.m_8055_(pos.m_142125_()).m_60734_().equals(Blocks.f_50662_) && isBuilded;
        isBuilded = world.m_8055_(pos.m_142126_()).m_60734_().equals(Blocks.f_50662_) && isBuilded;
        isBuilded = world.m_8055_(pos.m_7495_()).m_60734_().equals(Blocks.f_50711_) && isBuilded;
        isBuilded = world.m_8055_(pos.m_6625_(2)).m_60734_().equals(Blocks.f_50711_) && isBuilded;
        isBuilded = world.m_8055_(pos.m_6625_(3)).m_60734_().equals(Blocks.f_50734_) && isBuilded;
        return isBuilded;
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new WardshiperBlockEntity(p_153215_, p_153216_);
    }
}

