/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.config;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.LootTableHandler;
import com.dainxt.dungeonsmod.items.ItemArmorMaterials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class DungeonsModConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Server COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue playerLeaveGhost;
        public final ForgeConfigSpec.DoubleValue customDifficulty;
        public final ForgeConfigSpec.BooleanValue scalingDifficulty;
        public final ForgeConfigSpec.BooleanValue travelerInvocation;
        public final ForgeConfigSpec.BooleanValue sunInvocation;
        public final ForgeConfigSpec.BooleanValue lordSkeletonInvocation;
        public final ForgeConfigSpec.BooleanValue winterHunterInvocation;
        public final ForgeConfigSpec.IntValue cooldownHomeGem;
        public final ForgeConfigSpec.IntValue usageHomeGem;
        public final ForgeConfigSpec.IntValue cooldownSunOverdrive;
        public final ForgeConfigSpec.IntValue usageSunOverdrive;
        public final ItemConfiguration enableBackPergamine;
        public final ItemConfiguration enableHomeGem;
        public final ItemConfiguration enableGoldenBone;
        public final ItemConfiguration enableSunOverdrive;
        public final ItemConfiguration enableUnstableMap;
        public final ForgeConfigSpec.IntValue kingscrownDurabilityFactor;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> kingscrownArmor;
        public final ForgeConfigSpec.IntValue crawlerDurabilityFactor;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> crawlerArmor;
        public final ForgeConfigSpec.DoubleValue voidtomeDamage;
        public final ForgeConfigSpec.DoubleValue legendaryLootChance;
        public final BossConfiguration crawler;
        public final BossConfiguration deserted;
        public final BossConfiguration ironslime;
        public final BossConfiguration king;
        public final BossConfiguration kraken;
        public final BossConfiguration sun;
        public final BossConfiguration voidmaster;
        public final ForgeConfigSpec.BooleanValue killSwitch;
        public final MobConfiguration anthermite;
        public final MobConfiguration mimic;
        public final MobConfiguration piranha;
        public final MobConfiguration rogue;
        public final MobConfiguration slimond;
        public final MobConfiguration haunter;
        public final MobConfiguration lordskeleton;
        public final MobConfiguration deadhound;
        public final MobConfiguration crow;
        public final MobConfiguration notehead;
        public final MobConfiguration winterhunter;
        public final MobConfiguration pice;
        public final MobConfiguration leech;
        public final MobConfiguration pitcher;
        public final MobConfiguration whirlwind;
        public final MobConfiguration guard;
        public final MobConfiguration scientist;
        public final MobConfiguration slimewolf;
        public final ForgeConfigSpec.BooleanValue applyDatapackFix;
        public final ForgeConfigSpec.BooleanValue centerOnBiomes;
        public final StructureConfiguration dungeonside1;
        public final StructureConfiguration dungeonside21;
        public final StructureConfiguration dungeonside22;
        public final StructureConfiguration dungeonside31;
        public final StructureConfiguration dungeon0;
        public final StructureConfiguration dungeon1;
        public final StructureConfiguration dungeon2;
        public final StructureConfiguration dungeon3;
        public final StructureConfiguration dungeon4;
        public final StructureConfiguration dungeon5;
        public final StructureConfiguration dungeon6;
        public final StructureConfiguration dungeon7;
        public final ForgeConfigSpec.IntValue theOne;
        public final BlackListedBiomes blackStructures;
        public final BlackListedBiomes blackMobs;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Dungeons Mod Configuration Settings").push("general");
            this.playerLeaveGhost = builder.comment("Should players leave a ghost when they die? 0 to disable, 1 to always, 100/positiveValues chance").defineInRange("Ghost Players", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("bosses");
            this.crawler = new BossConfiguration(builder, EntityRegistries.CRAWLER, LootTableHandler.CRAWLER);
            this.deserted = new BossConfiguration(builder, EntityRegistries.DESERTED, LootTableHandler.DESERTED);
            this.ironslime = new BossConfiguration(builder, EntityRegistries.IRONSLIME, LootTableHandler.IRONSLIME);
            this.king = new BossConfiguration(builder, EntityRegistries.KING, LootTableHandler.KING);
            this.kraken = new BossConfiguration(builder, EntityRegistries.KRAKEN, LootTableHandler.KRAKEN);
            this.sun = new BossConfiguration(builder, EntityRegistries.SUN, LootTableHandler.SUN);
            this.voidmaster = new BossConfiguration(builder, EntityRegistries.VOIDMASTER, LootTableHandler.VOIDMASTER);
            builder.pop();
            builder.push("difficulty");
            this.customDifficulty = builder.comment("[BETA] For manual adjustment. Recommended number = (Highest Weapon Damage / 20) . For reference, Vanilla defaults equivalent : Easy = 0.25, Normal = 0.5, Hard = 0.75. Values > 1 requires Attribute Fix Mod. For using server difficulty = 0").defineInRange("Custom Difficulty Value", 0.0, -0.25, 1000.0);
            this.scalingDifficulty = builder.comment("[BETA] This will make bosses to scale with the number of players near and the world difficulty ").define("Multiplayer Scaling", true);
            builder.pop();
            builder.push("invocations");
            this.travelerInvocation = builder.comment("Enable Traveler invocation").define("Traveler Invocation", true);
            this.sunInvocation = builder.comment("Enable Sun invocation").define("Sun Invocation", true);
            this.lordSkeletonInvocation = builder.comment("Enable Lord Skeleton invocation").define("Lord Skeleton Invocation", true);
            this.winterHunterInvocation = builder.comment("Enable Winter Hunter invocation").define("Winter Hunter Invocation", true);
            builder.pop();
            builder.push("items");
            builder.push("times");
            this.cooldownHomeGem = builder.comment("Home Gem Cooldown in Ticks").defineInRange("Home Gem Cooldown", 18000, 0, Integer.MAX_VALUE);
            this.usageHomeGem = builder.comment("Home Gem Cast Time in Ticks").defineInRange("Home Gem Cast Time", 200, 0, Integer.MAX_VALUE);
            this.cooldownSunOverdrive = builder.comment("Sun Overdrive Cooldown in Ticks").defineInRange("Sun Overdrive Cooldown", 144000, 0, Integer.MAX_VALUE);
            this.usageSunOverdrive = builder.comment("Sun Overdrive Cast Time in Ticks").defineInRange("Sun Overdrive Cast Time", 200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("activations");
            this.enableBackPergamine = new ItemConfiguration(builder, "back_pergamine", true);
            this.enableHomeGem = new ItemConfiguration(builder, "home_gem", true);
            this.enableGoldenBone = new ItemConfiguration(builder, "golden_bone", true);
            this.enableSunOverdrive = new ItemConfiguration(builder, "sun_overdrive", true);
            this.enableUnstableMap = new ItemConfiguration(builder, "unstable_map", true);
            builder.pop();
            builder.push("legendary");
            this.kingscrownDurabilityFactor = builder.defineInRange("Crown Armor Durability Factor", ItemArmorMaterials.KINGCROWN.getDefaultMaxDamageFactor(), 1, 100);
            this.kingscrownArmor = builder.defineList("Crown Gold Armor Values (Boots, Leggins, Chestplate, Crown), only the last value is used", Arrays.stream(ItemArmorMaterials.KINGCROWN.getDefaultDamageReductionAmountArray()).boxed().collect(Collectors.toList()), o -> o instanceof Integer);
            this.crawlerDurabilityFactor = builder.defineInRange("Crawler Armor Durability Factor", ItemArmorMaterials.CRAWLER.getDefaultMaxDamageFactor(), 1, 100);
            this.crawlerArmor = builder.defineList("Crawler Armor Values (Boots, Leggins, Chestplate, Helmet)", Arrays.stream(ItemArmorMaterials.CRAWLER.getDefaultDamageReductionAmountArray()).boxed().collect(Collectors.toList()), o -> o instanceof Integer);
            this.voidtomeDamage = builder.defineInRange("Void Tome Damage", 8.0, 7.0, 1000.0);
            builder.pop();
            builder.pop();
            builder.push("loot");
            this.legendaryLootChance = builder.comment("Chance in % that have the bosses to drop legendary items").defineInRange("Legendary %", 33.0, 0.0, 100.0);
            builder.pop();
            builder.push("mobs");
            this.killSwitch = builder.comment("if you set a spawn weight to 0, the existance of such mob is vanished, else it only desactivates natural spawning. (Only affects problematic mobs)").define("Complete Desactivation", true);
            this.anthermite = new MobConfiguration(builder, EntityRegistries.ANTHERMITE, 2, LootTableHandler.ANTHERMITE);
            this.mimic = new MobConfiguration(builder, EntityRegistries.MIMIC, 5, LootTableHandler.MIMIC);
            this.piranha = new MobConfiguration(builder, EntityRegistries.PIRANHA, 2, LootTableHandler.PIRANHA);
            this.rogue = new MobConfiguration(builder, EntityRegistries.ROGUE, 1, LootTableHandler.ROGUE);
            this.slimond = new MobConfiguration(builder, EntityRegistries.SLIMOND, 1, LootTableHandler.SLIMOND);
            this.haunter = new MobConfiguration(builder, EntityRegistries.HAUNTER, 100, LootTableHandler.HAUNTER);
            this.lordskeleton = new MobConfiguration(builder, EntityRegistries.LORDSKELETON, 0, LootTableHandler.LORDSKELETON);
            this.deadhound = new MobConfiguration(builder, EntityRegistries.DEADHOUND, 0, LootTableHandler.DEADHOUND);
            this.crow = new MobConfiguration(builder, EntityRegistries.CROW, 4, LootTableHandler.CROW);
            this.notehead = new MobConfiguration(builder, EntityRegistries.NOTEHEAD, 1, LootTableHandler.NOTEHEAD);
            this.winterhunter = new MobConfiguration(builder, EntityRegistries.WINTERHUNTER, 0, LootTableHandler.WINTERHUNTER);
            this.pice = new MobConfiguration(builder, EntityRegistries.PICE, 3, LootTableHandler.PICE);
            this.leech = new MobConfiguration(builder, EntityRegistries.LEECH, 0, null);
            this.pitcher = new MobConfiguration(builder, EntityRegistries.PITCHER, 0, LootTableHandler.PITCHER);
            this.whirlwind = new MobConfiguration(builder, EntityRegistries.WHIRLWIND, 1, null);
            this.guard = new MobConfiguration(builder, EntityRegistries.GUARD, 100, LootTableHandler.GUARD, true);
            this.scientist = new MobConfiguration(builder, EntityRegistries.SCIENTIST, 100, LootTableHandler.SCIENTIST, true);
            this.slimewolf = new MobConfiguration(builder, EntityRegistries.SLIMEWOLF, 100, LootTableHandler.SLIMEWOLF, true);
            builder.comment("Blacklisted biomes in which no mobs will spawn").push("blacklisted-biomes");
            this.blackMobs = new BlackListedBiomes(builder);
            builder.pop();
            builder.pop();
            builder.push("structures");
            this.applyDatapackFix = builder.comment("Apply Fixes when using World Generation related Experimental Datapacks").define("Apply Datapack Fix", true);
            this.centerOnBiomes = builder.comment("Center Structures on Biomes (Could lead to incompatibilities with other mods)").define("Center On Biomes", false);
            this.dungeonside1 = new StructureConfiguration(builder, "the_chapel", 32, 8, 31632, 1, 0);
            this.dungeonside21 = new StructureConfiguration(builder, "the_nest", 16, 4, 58625, 1, 0);
            this.dungeonside22 = new StructureConfiguration(builder, "the_pitcher", 8, 2, 32127, 1, 0);
            this.dungeonside31 = new StructureConfiguration(builder, "the_sewers", 32, 8, 14341, 1, 0);
            this.dungeon0 = new StructureConfiguration(builder, "the_camp", 32, 8, 14357617, 1, 0);
            this.dungeon1 = new StructureConfiguration(builder, "the_house", 80, 20, 9326560, 1, 8);
            this.dungeon2 = new StructureConfiguration(builder, "the_iron_mines", 80, 20, 9326560, 1, 12);
            this.dungeon3 = new StructureConfiguration(builder, "the_ship", 80, 20, 214556, 1, 18);
            this.dungeon4 = new StructureConfiguration(builder, "the_castle", 80, 20, 5284629, 1, 32);
            this.dungeon5 = new StructureConfiguration(builder, "the_lab", 80, 20, 3241280, 1, 48);
            this.dungeon6 = new StructureConfiguration(builder, "the_catacombs", 80, 20, 3252381, 1, 0);
            this.dungeon7 = new StructureConfiguration(builder, "the_origin", 80, 20, 621556, 1, 0);
            builder.comment("Blacklisted biomes in which no structures will spawn").push("blacklisted-biomes");
            this.blackStructures = new BlackListedBiomes(builder);
            builder.pop();
            builder.pop();
            builder.push("traveler");
            this.theOne = builder.comment("Traveler does not spawn in this radius if theres another traveler near").defineInRange("The One radius", 128, 0, 1024);
            builder.pop();
        }

        public class BossConfiguration {
            public ForgeConfigSpec.ConfigValue<String> lootTable;

            BossConfiguration(ForgeConfigSpec.Builder builder, EntityType<?> entityType, ResourceLocation defaultLootTable) {
                String name = entityType.getRegistryName().m_135815_();
                builder.push(name);
                this.lootTable = defaultLootTable != null ? builder.define(this.capitalize(name) + " Loot Table", (Object)defaultLootTable.toString(), o -> o instanceof String) : null;
                builder.pop();
            }

            String capitalize(String str) {
                return str.substring(0, 1).toUpperCase() + str.substring(1);
            }

            public ResourceLocation getDefaultLootTable() {
                return this.lootTable != null ? new ResourceLocation((String)this.lootTable.get()) : null;
            }
        }

        public class ItemConfiguration {
            public final ForgeConfigSpec.BooleanValue activated;

            ItemConfiguration(ForgeConfigSpec.Builder builder, String name, boolean activated) {
                builder.push(name);
                this.activated = builder.define("Enable", activated);
                builder.pop();
            }

            public boolean isEnabled() {
                return (Boolean)this.activated.get();
            }
        }

        public class MobConfiguration {
            public ForgeConfigSpec.IntValue weight;
            public ForgeConfigSpec.ConfigValue<String> lootTable;
            public boolean capped;

            MobConfiguration(ForgeConfigSpec.Builder builder, EntityType<?> entityType, int defaultWeight, ResourceLocation defaultLootTable) {
                this(builder, entityType, defaultWeight, defaultLootTable, false);
            }

            MobConfiguration(ForgeConfigSpec.Builder builder, EntityType<?> entityType, int defaultWeight, ResourceLocation defaultLootTable, boolean capped) {
                String name = entityType.getRegistryName().m_135815_();
                builder.push(name);
                this.weight = defaultWeight > 0 ? builder.defineInRange(this.capitalize(name) + " Weight" + (capped ? "(Percentage)" : ""), defaultWeight, 0, capped ? 100 : Integer.MAX_VALUE) : null;
                this.lootTable = defaultLootTable != null ? builder.define(this.capitalize(name) + " Loot Table", (Object)defaultLootTable.toString(), o -> o instanceof String) : null;
                builder.pop();
            }

            String capitalize(String str) {
                return str.substring(0, 1).toUpperCase() + str.substring(1);
            }

            public int getWeight() {
                return this.weight != null ? (Integer)this.weight.get() : 0;
            }

            public ResourceLocation getDefaultLootTable() {
                return this.lootTable != null ? new ResourceLocation((String)this.lootTable.get()) : null;
            }
        }

        public class BlackListedBiomes {
            public final List<String> DEFAULT_BLACKLIST = Arrays.asList(Biomes.f_48184_.m_135782_().toString());
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blackList;

            BlackListedBiomes(ForgeConfigSpec.Builder builder) {
                this.blackList = builder.defineList("Blacklisted Biomes", this.DEFAULT_BLACKLIST, o -> o instanceof String);
            }

            public List<Biome> get() {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (String location : (List)this.blackList.get()) {
                    ResourceLocation resourceLocation = new ResourceLocation(location);
                    if (!ForgeRegistries.BIOMES.containsKey(resourceLocation)) continue;
                    biomes.add((Biome)ForgeRegistries.BIOMES.getValue(resourceLocation));
                }
                if (biomes.isEmpty()) {
                    DungeonsMod.LOGGER.info("Warning!: The following biomes blacklisted were not founded:", this.blackList.get());
                }
                return biomes;
            }
        }

        public class StructureConfiguration {
            public final ForgeConfigSpec.IntValue spacing;
            public final ForgeConfigSpec.IntValue separation;
            public final ForgeConfigSpec.IntValue seedModifier;
            public final ForgeConfigSpec.IntValue chance;
            public final ForgeConfigSpec.IntValue price;

            StructureConfiguration(ForgeConfigSpec.Builder builder, String name, int spacing, int separation, int seedModifier, int chance, int price) {
                builder.push(name);
                this.spacing = builder.defineInRange("Spacing", spacing, 0, Integer.MAX_VALUE);
                this.separation = builder.defineInRange("Separation", separation, 0, Integer.MAX_VALUE);
                this.seedModifier = builder.defineInRange("Seed Modifier", seedModifier, 0, Integer.MAX_VALUE);
                this.chance = builder.comment("1 to always, 100/positiveValues chance").defineInRange("Spawing Chance", chance, 0, Integer.MAX_VALUE);
                this.price = price > 0 ? builder.defineInRange("Price", price, 0, 64) : null;
                builder.pop();
            }

            public StructureFeatureConfiguration get() {
                return new StructureFeatureConfiguration(((Integer)this.spacing.get()).intValue(), ((Integer)this.separation.get()).intValue(), ((Integer)this.seedModifier.get()).intValue());
            }
        }
    }
}

