/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.difficulty;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.Collection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DifficultyManager {
    int prevNumberPlayers;

    public void adjustDifficulty(LivingEntity attacker) {
        if (attacker != null) {
            float difficultyFactor = (float)(Math.signum((Double)DungeonsModConfig.COMMON.customDifficulty.get()) != 0.0 ? (Double)DungeonsModConfig.COMMON.customDifficulty.get() : (double)((float)attacker.f_19853_.m_46791_().m_19028_() / 4.0f));
            float difference = attacker.m_21233_() - attacker.m_21223_();
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22276_);
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22284_);
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22281_);
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22283_);
            if (attacker.m_21233_() - difference <= 0.0f) {
                attacker.m_21153_(0.0f);
            } else {
                attacker.m_21153_(attacker.m_21233_() - difference);
            }
        }
    }

    public static void adjustAttribute(LivingEntity attacker, float difficulty, Attribute attribute) {
        if (attacker.m_21051_(attribute) != null) {
            float totalMultiplier = difficulty;
            for (AttributeModifier modifier : attacker.m_21051_(attribute).m_22122_()) {
                if (!modifier.m_22214_().equals("DMDifficultyBase") && !modifier.m_22214_().equals("ScalingModifier")) continue;
                attacker.m_21051_(attribute).m_22127_(modifier.m_22209_());
            }
            attacker.m_21051_(attribute).m_22125_(new AttributeModifier("DMDifficultyBase", (double)totalMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public void adjustDifficulty(LivingEntity attacker, float pppHealth, float pppArmor, float pppDamage, float pppSpeed, Collection<ServerPlayer> collection) {
        int actualPlayerCount;
        if (attacker != null && collection != null && this.prevNumberPlayers != (actualPlayerCount = Mth.m_14045_((int)((int)collection.stream().filter(EntitySelector.f_20406_).count()), (int)1, (int)Integer.MAX_VALUE))) {
            float difficultyFactor = (float)(Math.signum((Double)DungeonsModConfig.COMMON.customDifficulty.get()) != 0.0 ? (Double)DungeonsModConfig.COMMON.customDifficulty.get() : (double)((float)attacker.f_19853_.m_46791_().m_19028_() / 4.0f));
            float difference = attacker.m_21233_() - attacker.m_21223_();
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22276_, actualPlayerCount, pppHealth);
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22284_, actualPlayerCount, pppArmor);
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22281_, actualPlayerCount, pppDamage);
            DifficultyManager.adjustAttribute(attacker, difficultyFactor, Attributes.f_22283_, actualPlayerCount, pppSpeed);
            if (attacker.m_21233_() - difference <= 0.0f) {
                attacker.m_21153_(0.0f);
            } else {
                attacker.m_21153_(attacker.m_21233_() - difference);
            }
            this.prevNumberPlayers = actualPlayerCount;
        }
    }

    public static void adjustAttribute(LivingEntity attacker, float difficulty, Attribute attribute, int numberPlayers, float ppp) {
        if (attacker.m_21051_(attribute) != null) {
            if (attribute == Attributes.f_22276_) {
                // empty if block
            }
            float totalMultiplier = difficulty;
            float addValue = (float)((double)(ppp * (float)(numberPlayers - 1)) * attacker.m_21051_(attribute).m_22115_());
            for (AttributeModifier modifier : attacker.m_21051_(attribute).m_22122_()) {
                if (!modifier.m_22214_().equals("DMDifficultyModifier") && !modifier.m_22214_().equals("DMDifficultyBase") && !modifier.m_22214_().equals("ScalingModifier")) continue;
                attacker.m_21051_(attribute).m_22127_(modifier.m_22209_());
            }
            if (numberPlayers > 0) {
                attacker.m_21051_(attribute).m_22125_(new AttributeModifier("DMDifficultyBase", (double)totalMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                attacker.m_21051_(attribute).m_22125_(new AttributeModifier("DMDifficultyModifier", (double)addValue, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public static float getTotalAttributePPP(LivingEntity attacker, Attribute attribute) {
        return (float)(attacker.m_21051_(attribute).m_22135_() / attacker.m_21051_(attribute).m_22115_());
    }
}

