/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.ai.AITimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.handlers.LootTableHandler;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;

public class EntityAnthermite
extends Monster {
    public EntityAnthermite(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.m_21553_(true);
        this.f_21364_ = 1;
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.ANTHERMITE;
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (DungeonsModConfig.COMMON.anthermite.getWeight() <= 0 && ((Boolean)DungeonsModConfig.COMMON.killSwitch.get()).booleanValue()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean haveSugar() {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == Items.f_42501_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AIDoNothing(this, 120, 20));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22281_, 0.2).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 1.0);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            if (this.m_21187_().nextInt(10) == 0) {
                entityIn.m_20254_(1);
            }
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                ItemStack stackOnInteractionHand = player.f_36095_.m_142621_();
                if (!stackOnInteractionHand.m_41619_() && !this.haveSugar() && stackOnInteractionHand.m_41720_() == Items.f_42501_) {
                    ItemStack robbedStack = stackOnInteractionHand.m_41777_();
                    robbedStack.m_41764_(1);
                    this.m_8061_(EquipmentSlot.MAINHAND, robbedStack);
                    stackOnInteractionHand.m_41774_(1);
                }
            }
        }
        return flag;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.m_21187_().nextInt(20) == 0) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123800_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.m_20069_()) {
            this.m_6469_(DamageSource.f_19312_, (float)this.m_21051_(Attributes.f_22276_).m_22135_());
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (!this.haveSugar() && itemstack.m_41720_() == Items.f_42501_) {
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            ItemStack excessStack = itemstack.m_41777_();
            if (excessStack.m_41613_() > 1) {
                excessStack.m_41774_(1);
                this.m_5552_(excessStack, 0.0f);
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.7f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11937_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11937_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    class AIDoNothing
    extends AITimedAction {
        EntityAnthermite anthermite;

        public AIDoNothing(EntityAnthermite entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.anthermite = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            return this.anthermite.haveSugar();
        }

        @Override
        public boolean m_8045_() {
            boolean flag;
            boolean bl = flag = !super.m_8045_();
            if (flag) {
                this.attacker.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
            return this.anthermite.haveSugar();
        }
    }
}

