/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IEntityExtraPart;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityExtraPart
extends Mob {
    private static final EntityDataAccessor<Integer> PARTTYPE = SynchedEntityData.m_135353_(EntityExtraPart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.m_135353_(EntityExtraPart.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> PARENT_ID = SynchedEntityData.m_135353_(EntityExtraPart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACKTARGET_ID = SynchedEntityData.m_135353_(EntityExtraPart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private String cachedUniqueIdParent = null;

    public EntityExtraPart(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
        this.m_21530_();
    }

    public EntityExtraPart(Mob parent, String name, float p_i50232_3_, float p_i50232_4_) {
        super(EntityRegistries.EXTRAPART, parent.f_19853_);
        this.setParentID(parent.m_142049_());
        this.cachedUniqueIdParent = parent.m_142081_().toString();
        this.setPartName(name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARTTYPE, (Object)-1);
        this.f_19804_.m_135372_(NAME, (Object)String.valueOf("None"));
        this.f_19804_.m_135372_(PARENT_ID, (Object)-1);
        this.f_19804_.m_135372_(ATTACKTARGET_ID, (Object)-1);
    }

    public void setPartType(ExtraPartType type) {
        this.m_20088_().m_135381_(PARTTYPE, (Object)type.getIndex());
    }

    public ExtraPartType getPartType() {
        return ExtraPartType.byIndex((Integer)this.m_20088_().m_135370_(PARTTYPE));
    }

    public EntityExtraPart setParentID(int bindedPlayer) {
        if (!this.f_19853_.f_46443_ && bindedPlayer < 0) {
            this.cachedUniqueIdParent = null;
        }
        this.m_20088_().m_135381_(PARENT_ID, (Object)bindedPlayer);
        return this;
    }

    public int getParentID() {
        return (Integer)this.m_20088_().m_135370_(PARENT_ID);
    }

    public void m_6710_(LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
        this.m_20088_().m_135381_(ATTACKTARGET_ID, (Object)(entitylivingbaseIn == null ? -1 : entitylivingbaseIn.m_142049_()));
    }

    public LivingEntity m_5448_() {
        return (LivingEntity)this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(ATTACKTARGET_ID)).intValue());
    }

    public EntityExtraPart setPartName(String bindedPlayer) {
        this.m_20088_().m_135381_(NAME, (Object)String.valueOf(bindedPlayer));
        return this;
    }

    public String getPartName() {
        return ((String)this.m_20088_().m_135370_(NAME)).toString();
    }

    public boolean isAlivePart() {
        return this.m_21223_() > 1.0f;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.equals(DamageSource.f_19310_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (data != null) {
            this.setPartType(((GroupData)data).partType);
            if (((GroupData)data).partType == ExtraPartType.TENTACLE) {
                this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
                this.m_21051_(Attributes.f_22284_).m_22100_(10.0);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                this.m_21051_(Attributes.f_22278_).m_22100_(1.0);
                this.m_21153_(this.m_21233_());
            }
            if (((GroupData)data).partType == ExtraPartType.VOIDHAND) {
                this.f_20885_ = 270.0f;
            }
        }
        return data;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPartType(ExtraPartType.byIndex(compound.m_128451_("PartType")));
        this.setPartName(compound.m_128461_("PartName"));
        if (!this.f_19853_.f_46443_) {
            this.cachedUniqueIdParent = !compound.m_128461_("BindedEntityUUID").isEmpty() ? compound.m_128461_("BindedEntityUUID") : null;
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("PartType", this.getPartType().getIndex());
        compound.m_128359_("PartName", this.getPartName());
        if (!this.f_19853_.f_46443_ && this.cachedUniqueIdParent != null) {
            compound.m_128359_("BindedEntityUUID", this.cachedUniqueIdParent);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_8107_() {
        Entity parent;
        super.m_8107_();
        if (this.getParentID() != -1 && (parent = this.f_19853_.m_6815_(this.getParentID())) instanceof IEntityExtraPart && !((IEntityExtraPart)parent).getCustomParts().contains((Object)this) && this.m_6084_()) {
            ((IEntityExtraPart)parent).getCustomParts().add(this);
        }
    }

    public void m_6667_(DamageSource cause) {
        Entity parent;
        if (this.getParentID() != -1 && (parent = this.f_19853_.m_6815_(this.getParentID())) instanceof IEntityExtraPart) {
            this.m_21153_(1.0f);
            return;
        }
        super.m_6667_(cause);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.updateParentUUID();
    }

    public void updateParentUUID() {
        if (!this.f_19853_.f_46443_) {
            if (this.cachedUniqueIdParent == null) {
                this.cachedUniqueIdParent = this.f_19853_.m_6815_(this.getParentID()) != null ? this.f_19853_.m_6815_(this.getParentID()).m_20149_() : null;
            } else if (((ServerLevel)this.f_19853_).m_8791_(UUID.fromString(this.cachedUniqueIdParent)) != null) {
                this.setParentID(((ServerLevel)this.f_19853_).m_8791_(UUID.fromString(this.cachedUniqueIdParent)).m_142049_());
            }
        }
    }

    public boolean isEntityEqual(Entity entityIn) {
        return this == entityIn || this.f_19853_.m_6815_(this.getParentID()) == entityIn;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6043_() {
    }

    public static enum ExtraPartType {
        NONE(-1),
        TENTACLE(0),
        VOIDHAND(1);

        private int index;

        private ExtraPartType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ExtraPartType byIndex(int index) {
            for (ExtraPartType equipmentslottype : ExtraPartType.values()) {
                if (equipmentslottype.getIndex() != index) continue;
                return equipmentslottype;
            }
            return NONE;
        }
    }

    public static class GroupData
    implements SpawnGroupData {
        ExtraPartType partType;

        public GroupData(ExtraPartType partType) {
            this.partType = partType;
        }
    }
}

