/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityHaunter
extends Monster {
    public EntityHaunter(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
        this.f_19794_ = true;
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.haunter.getDefaultLootTable();
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        if (worldIn.m_46857_(pos).m_47567_() == Biome.BiomeCategory.SWAMP) {
            return Monster.m_33017_(type, (ServerLevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
        }
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (DungeonsModConfig.COMMON.haunter.getWeight() <= 0 && ((Boolean)DungeonsModConfig.COMMON.killSwitch.get()).booleanValue()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AIAttack(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, null));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 1.0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        if (entityIn instanceof LivingEntity && !(entityIn instanceof EntityHaunter)) {
            entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        }
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
        if (entityIn instanceof LivingEntity) {
            entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.f_19853_.f_46443_) {
            BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            float f = 0.65f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.65f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.f_19861_ ? 0.1f * f1 : 0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityHaunter parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityHaunter ghast) {
            super((Mob)ghast);
            this.parentEntity = ghast;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_21187_().nextInt(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                vector3d = vector3d.m_82541_();
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
            }
        }
    }

    static class AIAttack
    extends Goal {
        private final EntityHaunter parentEntity;
        public int attackTimer;

        public AIAttack(EntityHaunter Sun) {
            this.parentEntity = Sun;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            LivingEntity LivingEntity2 = this.parentEntity.m_5448_();
            double d0 = 64.0;
            if (LivingEntity2.m_20280_((Entity)this.parentEntity) < 4096.0 && this.parentEntity.m_142582_((Entity)LivingEntity2)) {
                Level world = this.parentEntity.f_19853_;
                double d2 = LivingEntity2.m_20185_();
                double d3 = LivingEntity2.m_20186_();
                double d4 = LivingEntity2.m_20189_();
                this.parentEntity.m_21566_().m_6849_(d2, d3, d4, 0.5);
            }
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityHaunter parentEntity;

        public RandomFlyGoal(EntityHaunter ghast) {
            this.parentEntity = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Random random = this.parentEntity.m_21187_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityHaunter parentEntity;

        public LookAroundGoal(EntityHaunter ghast) {
            this.parentEntity = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 vector3d = this.parentEntity.m_20184_();
                this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
                this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
            } else {
                LivingEntity livingentity = this.parentEntity.m_5448_();
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.parentEntity.m_20185_();
                    double d2 = livingentity.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
        }
    }
}

