/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.block.WardshiperBlock;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityDeadhound;
import com.dainxt.dungeonsmod.entity.EntityHaunter;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class EntityLordSkeleton
extends Monster
implements IMultiTargetEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_7755_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    public ArrayList<LivingEntity> otherAttackTargets = new ArrayList();

    public EntityLordSkeleton(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 500;
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.lordskeleton.getDefaultLootTable();
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof WardshiperBlock) {
            long totalPlayers = this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).count();
            float totalChance = Mth.m_14036_((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.f_19853_.m_5822_().nextFloat() < totalChance / 100.0f) {
                return super.m_5552_(stack, offsetY);
            }
            return super.m_5552_(ItemStack.f_41583_, offsetY);
        }
        return super.m_5552_(stack, offsetY);
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        if (worldIn.m_46857_(pos).m_47567_() == Biome.BiomeCategory.SWAMP) {
            return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
        }
        if (randomIn.nextInt(30) == 0) {
            return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
        }
        return false;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 195.0).m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 20.0);
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        this.otherAttackTargets = players;
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        return this.otherAttackTargets;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8024_() {
        ServerLevel serverworld;
        Monster traveler;
        super.m_8024_();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.5f, 0.5f, 0.5f, 0.5f, this.bossInfo.m_8324_());
        }
        if (this.f_19797_ % 300 == 0 && !this.f_19853_.f_46443_) {
            for (Player player : this.bossInfo.m_8324_()) {
                if (player.m_7500_() || player.m_5833_()) continue;
                traveler = new EntityHaunter(EntityRegistries.HAUNTER, this.f_19853_);
                serverworld = (ServerLevel)this.f_19853_;
                traveler.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                traveler.m_6518_((ServerLevelAccessor)serverworld, this.f_19853_.m_6436_(traveler.m_142538_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                traveler.m_6710_((LivingEntity)player);
                this.f_19853_.m_7967_((Entity)traveler);
            }
        }
        if (this.f_19797_ % 400 == 0 && !this.f_19853_.f_46443_) {
            for (Player player : this.bossInfo.m_8324_()) {
                if (player.m_7500_() || player.m_5833_()) continue;
                traveler = new EntityDeadhound(EntityRegistries.DEADHOUND, this.f_19853_);
                serverworld = (ServerLevel)this.f_19853_;
                traveler.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                traveler.m_6518_((ServerLevelAccessor)serverworld, this.f_19853_.m_6436_(traveler.m_142538_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                this.f_19853_.m_7967_((Entity)traveler);
                traveler.m_6710_((LivingEntity)player);
                this.f_19853_.m_7785_(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_(), SoundEvents.f_12620_, SoundSource.HOSTILE, 1.0f, 5.0f, false);
            }
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.bossInfo.m_8324_().isEmpty()) {
            this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22115_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public List<ServerPlayer> getPlayers() {
        return this.bossInfo.m_8324_().stream().filter(EntitySelector.f_20406_).collect(Collectors.toList());
    }

    public boolean m_21532_() {
        return !this.bossInfo.m_8324_().isEmpty();
    }

    public void m_6043_() {
        if (this.bossInfo.m_8324_().isEmpty()) {
            super.m_6043_();
        }
    }
}

