/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;

public class EntityMimic
extends Monster {
    private static final EntityDataAccessor<Boolean> WAITING = SynchedEntityData.m_135353_(EntityMimic.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityMimic(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 7;
        this.f_21342_ = new MoveHelperController(this);
    }

    protected ResourceLocation m_7582_() {
        return this.m_21187_().nextInt(20) == 0 ? BuiltInLootTables.f_78742_ : DungeonsModConfig.COMMON.mimic.getDefaultLootTable();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WAITING, (Object)false);
    }

    public void setWaiting(boolean isWaiting) {
        this.m_20088_().m_135381_(WAITING, (Object)isWaiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(WAITING);
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return randomIn.nextInt(20) == 0 && Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean func_241845_aY() {
        return this.m_6084_();
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
        if (!this.isWaiting()) {
            this.m_7327_((Entity)entityIn);
        }
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        if (!this.isWaiting()) {
            this.m_7327_(entityIn);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        if (source.m_7639_() instanceof Player && (player = (Player)source.m_7639_()).m_21205_().canPerformAction(ToolActions.AXE_DIG)) {
            return super.m_6469_(source, amount * 1.25f);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new WaitGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HideGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 5.0).m_22268_(Attributes.f_22284_, 30.0);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setWaiting(compound.m_128471_("Waiting"));
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        compound.m_128379_("Waiting", this.isWaiting());
        return super.m_20240_(compound);
    }

    private void faceBlockPos(BlockPos pos) {
        double d0 = (double)pos.m_123341_() - this.m_20185_();
        double d2 = (double)pos.m_123343_() - this.m_20189_();
        double d1 = (double)pos.m_123342_() - this.m_20186_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
        this.m_146926_(f1);
        this.m_146922_(f);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        this.m_6710_((LivingEntity)player);
        return super.m_7111_(player, vec, hand);
    }

    public int getJumpDelay() {
        return 10;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float m_6118_() {
        return 0.3f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12634_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12633_;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_11749_;
    }

    static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final EntityMimic slime;
        private boolean isAggressive;

        public MoveHelperController(EntityMimic slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_() * 0.2f, 1.0f);
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class WaitGoal
    extends Goal {
        private final EntityMimic slime;

        public WaitGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public void m_8056_() {
            super.m_8056_();
            this.slime.m_6034_((double)Mth.m_14107_((double)this.slime.m_20185_()) + 0.5, this.slime.m_20186_(), (double)Mth.m_14107_((double)this.slime.m_20189_()) + 0.5);
        }

        public boolean m_8036_() {
            return this.slime.isWaiting();
        }

        public boolean m_8045_() {
            boolean flag;
            boolean bl = flag = this.slime.m_5448_() == null;
            if (!flag) {
                this.slime.setWaiting(false);
            }
            return flag;
        }
    }

    static class HideGoal
    extends Goal {
        private final EntityMimic slime;
        Direction direction;

        public HideGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.slime.m_6034_((double)Mth.m_14107_((double)this.slime.m_20185_()) + 0.5, this.slime.m_20186_(), (double)Mth.m_14107_((double)this.slime.m_20189_()) + 0.5);
            this.direction = Direction.m_122407_((int)this.slime.m_21187_().nextInt(4));
        }

        public void getNewDirection() {
            this.direction = Direction.m_122407_((int)this.slime.m_21187_().nextInt(4));
        }

        public boolean m_8045_() {
            boolean flag = this.slime.f_19853_.m_8055_(this.slime.m_142538_().m_142300_(this.direction)).m_60815_();
            if (flag) {
                if (this.slime.m_21566_() instanceof MoveHelperController) {
                    ((MoveHelperController)this.slime.m_21566_()).setDirection(this.slime.m_146908_() + 180.0f, this.slime.canDamagePlayer());
                }
                this.slime.setWaiting(true);
            }
            return !flag;
        }

        public void m_8037_() {
            List frontEntities = this.slime.f_19853_.m_45976_(LivingEntity.class, new AABB(this.slime.m_142538_().m_142300_(this.direction)));
            if (!frontEntities.isEmpty()) {
                for (Entity entity : frontEntities) {
                    if (entity.m_7306_((Entity)this.slime)) continue;
                    this.getNewDirection();
                    break;
                }
            }
            if (this.slime.m_21566_() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.m_21566_()).setDirection(this.direction.m_122416_(), this.slime.canDamagePlayer());
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntityMimic slime;
        private int inflateTieredTimer;

        public AttackGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_ ? false : this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8056_() {
            this.inflateTieredTimer = 100;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) {
                return false;
            }
            return --this.inflateTieredTimer > 0;
        }

        public void m_8037_() {
            this.slime.m_21391_((Entity)this.slime.m_5448_(), 10.0f, 10.0f);
            if (this.slime.m_21566_() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.canDamagePlayer());
            }
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntityMimic slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.f_19861_ || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.m_21187_().nextInt(60);
                this.chosenDegrees = this.slime.m_21187_().nextInt(360);
            }
            if (this.slime.m_21566_() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final EntityMimic slime;

        public HopGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            if (this.slime.m_21566_() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.0);
            }
        }
    }
}

