/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityPice
extends TamableAnimal {
    private static final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.f_41980_, Items.f_41898_});

    public EntityPice(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.pice.getDefaultLootTable();
    }

    public static boolean canSpawn(EntityType<? extends Animal> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return Animal.m_27577_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (DungeonsModConfig.COMMON.pice.getWeight() <= 0 && ((Boolean)DungeonsModConfig.COMMON.killSwitch.get()).booleanValue()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 0.2).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && source.m_7640_() instanceof LivingEntity) {
            source.m_7640_().m_6469_(DamageSource.m_19335_((Entity)this), 1.0f);
            if (source.m_7639_() != null) {
                if (this.m_142480_() instanceof Player && source.m_7639_().m_142081_() != this.m_142504_() && this.f_19796_.nextInt(3) == 0) {
                    this.m_142480_().m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 0));
                }
                if (this.m_142480_() instanceof Player) {
                    // empty if block
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21051_(Attributes.f_22279_).m_22100_((double)0.15f);
        if (this.m_20069_()) {
            this.m_6469_(DamageSource.f_19312_, (float)this.m_21051_(Attributes.f_22276_).m_22135_());
        }
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (!this.m_21824_() && TAME_ITEMS.contains(itemstack.m_41720_())) {
            if (!p_230254_1_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.f_19796_.nextInt(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_230254_1_)) {
                    this.m_21828_(p_230254_1_);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)p_230254_1_)) {
            if (!this.f_19853_.f_46443_) {
                this.m_21839_(!this.m_21827_());
                if (TAME_ITEMS.contains(itemstack.m_41720_()) && this.m_21223_() < this.m_21233_()) {
                    if (!this.f_19853_.f_46443_) {
                        if (!p_230254_1_.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        this.m_5634_(10.0f);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.7f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11983_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }
}

