/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityPiranha
extends AbstractFish {
    protected RandomSwimmingGoal wander;

    public EntityPiranha(EntityType<? extends AbstractFish> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.piranha.getDefaultLootTable();
    }

    public static boolean canSpawn(EntityType<? extends EntityPiranha> p_223329_0_, LevelAccessor p_223329_1_, MobSpawnType reason, BlockPos p_223329_3_, Random p_223329_4_) {
        return !(p_223329_4_.nextInt(60) != 0 && p_223329_1_.m_45527_(p_223329_3_) || p_223329_1_.m_46791_() == Difficulty.PEACEFUL || reason != MobSpawnType.SPAWNER && !p_223329_1_.m_6425_(p_223329_3_).m_76153_((Tag)FluidTags.f_13131_));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22281_, 0.2).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22277_, 10.0);
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5448_() != null) {
            Vec3 vec = this.m_5448_().m_20182_();
            this.m_21563_().m_24964_(vec);
            this.m_6034_(vec.f_82479_, vec.f_82480_ + (double)this.m_5448_().m_20192_(), vec.f_82481_);
        }
        if (DungeonsModConfig.COMMON.piranha.getWeight() <= 0 && ((Boolean)DungeonsModConfig.COMMON.killSwitch.get()).booleanValue()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource p_147189_) {
        if (this.m_5448_() != null) {
            this.m_5634_(0.8f);
            return super.m_142535_(Mth.m_14036_((float)distance, (float)0.0f, (float)4.0f), damageMultiplier, p_147189_);
        }
        return super.m_142535_(distance, damageMultiplier, p_147189_);
    }

    protected void m_8099_() {
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
        this.wander = new RandomSwimmingGoal((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)movetowardsrestrictiongoal);
        this.f_21345_.m_25352_(7, (Goal)this.wander);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, EntityPiranha.class, 12.0f, 0.01f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.wander.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, (Predicate)new TargetPredicate(this)));
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)ItemRegistries.PIRANHA_BUCKET);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.3f;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_11760_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityPiranha entityGuardian;

        public MoveHelperController(EntityPiranha EntityPiranha2) {
            super((Mob)EntityPiranha2);
            this.entityGuardian = EntityPiranha2;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.entityGuardian.m_21573_().m_26571_()) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.entityGuardian.m_20185_(), this.f_24976_ - this.entityGuardian.m_20186_(), this.f_24977_ - this.entityGuardian.m_20189_());
                double d0 = vector3d.m_82553_();
                double d1 = vector3d.f_82479_ / d0;
                double d2 = vector3d.f_82480_ / d0;
                double d3 = vector3d.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.2957763671875) - 90.0f;
                this.entityGuardian.m_146922_(this.m_24991_(this.entityGuardian.m_146908_(), f, 90.0f));
                this.entityGuardian.f_20883_ = this.entityGuardian.m_146908_();
                float f1 = (float)(this.f_24978_ * this.entityGuardian.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.entityGuardian.m_6113_(), (float)f1);
                this.entityGuardian.m_7910_(f2);
                double d4 = Math.sin((double)(this.entityGuardian.f_19797_ + this.entityGuardian.m_142049_()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.m_146908_() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entityGuardian.m_146908_() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.entityGuardian.f_19797_ + this.entityGuardian.m_142049_()) * 0.75) * 0.05;
                this.entityGuardian.m_20256_(this.entityGuardian.m_20184_().m_82520_(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookControl lookcontroller = this.entityGuardian.m_21563_();
                double d8 = this.entityGuardian.m_20185_() + d1 * 2.0;
                double d9 = this.entityGuardian.m_20188_() + d2 / d0;
                double d10 = this.entityGuardian.m_20189_() + d3 * 2.0;
                double d11 = lookcontroller.m_24969_();
                double d12 = lookcontroller.m_24970_();
                double d13 = lookcontroller.m_24971_();
                if (!lookcontroller.m_24968_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.entityGuardian.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.entityGuardian.m_7910_(0.0f);
            }
        }
    }

    static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final EntityPiranha parentEntity;

        public TargetPredicate(EntityPiranha EntityPiranha2) {
            this.parentEntity = EntityPiranha2;
        }

        @Override
        public boolean test(@Nullable LivingEntity p_test_1_) {
            return p_test_1_ instanceof Player && p_test_1_.m_20280_((Entity)this.parentEntity) > 9.0;
        }
    }
}

