/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.EntityWinterHunter;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.LootTableHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;

public class EntityPitcher
extends Monster {
    private static final EntityDataAccessor<Integer> BINDED_PLAYER = SynchedEntityData.m_135353_(EntityPitcher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private String cachedUniqueIdBinded = null;

    public EntityPitcher(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 10;
        this.m_21530_();
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.PITCHER;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BINDED_PLAYER, (Object)-1);
    }

    public void setEntityBinded(int bindedPlayer) {
        if (!this.f_19853_.f_46443_ && bindedPlayer < 0) {
            this.cachedUniqueIdBinded = null;
        }
        this.m_20088_().m_135381_(BINDED_PLAYER, (Object)bindedPlayer);
    }

    public int getEntityBinded() {
        return (Integer)this.m_20088_().m_135370_(BINDED_PLAYER);
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        if (source.m_7639_() instanceof Player && !this.f_19853_.f_46443_ && ((player = (Player)source.m_7639_()).m_21205_().canPerformAction(ToolActions.HOE_DIG) || player.m_21205_().m_41720_().equals(Items.f_42574_))) {
            this.setEntityBinded(-1);
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_6034_((int)this.m_20185_(), this.m_20186_(), (int)this.m_20189_());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, true, (Predicate)((Object)new PitcherTargetSelector(this))));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 2.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!this.f_19853_.f_46443_) {
            this.cachedUniqueIdBinded = !compound.m_128461_("BindedEntityUUID").isEmpty() ? compound.m_128461_("BindedEntityUUID") : null;
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.f_19853_.f_46443_ && this.cachedUniqueIdBinded != null) {
            compound.m_128359_("BindedEntityUUID", this.cachedUniqueIdBinded);
        }
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        return super.m_20240_(compound);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && entityIn instanceof LivingEntity && !this.f_19853_.f_46443_) {
            AABB box = this.m_142469_().m_82400_(60.0);
            ServerLevel serverworld = (ServerLevel)this.f_19853_;
            boolean shouldInvokeHunter = false;
            if (((Boolean)DungeonsModConfig.COMMON.winterHunterInvocation.get()).booleanValue()) {
                if (entityIn instanceof Player) {
                    ItemStack armorPiece;
                    boolean haveArmor = false;
                    Iterator iterator = entityIn.m_6168_().iterator();
                    while (iterator.hasNext() && !(haveArmor = !(armorPiece = (ItemStack)iterator.next()).m_41619_())) {
                    }
                    shouldInvokeHunter = !haveArmor;
                } else if (entityIn instanceof LivingEntity) {
                    shouldInvokeHunter = this.m_21187_().nextInt(60) == 0;
                }
            } else if (entityIn instanceof Player) {
                Player playerentity = (Player)entityIn;
                playerentity.m_5661_((Component)new TranslatableComponent("entity.dungeonsmod.winterhunter.invocation.denied"), true);
            }
            List suns = serverworld.m_143280_(EntityRegistries.WINTERHUNTER, EntitySelector.f_20408_);
            if (suns.isEmpty() && shouldInvokeHunter) {
                EntityWinterHunter traveler = new EntityWinterHunter(EntityRegistries.WINTERHUNTER, this.f_19853_);
                int finalX = (int)this.m_20185_() + 7 * (this.f_19796_.nextBoolean() ? 1 : -1);
                int finalZ = (int)this.m_20189_() + 7 * (this.f_19796_.nextBoolean() ? 1 : -1);
                int finalY = this.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, finalX, finalZ);
                traveler.m_7678_(finalX, finalY, finalZ, 0.0f, 0.0f);
                traveler.m_6518_((ServerLevelAccessor)serverworld, this.f_19853_.m_6436_(traveler.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.f_19853_.m_7967_((Entity)traveler);
            }
            this.setEntityBinded(((LivingEntity)entityIn).m_142049_());
        }
        return flag;
    }

    public void m_8107_() {
        LivingEntity entity;
        super.m_8107_();
        if (this.getEntityBinded() != -1 && (entity = (LivingEntity)this.f_19853_.m_6815_(this.getEntityBinded())) != null) {
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5448_() == null && this.getEntityBinded() != -1) {
            this.setEntityBinded(-1);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.cachedUniqueIdBinded == null) {
                this.cachedUniqueIdBinded = this.f_19853_.m_6815_(this.getEntityBinded()) != null ? this.f_19853_.m_6815_(this.getEntityBinded()).m_20149_() : null;
            } else if (((ServerLevel)this.f_19853_).m_8791_(UUID.fromString(this.cachedUniqueIdBinded)) != null) {
                this.setEntityBinded(((ServerLevel)this.f_19853_).m_8791_(UUID.fromString(this.cachedUniqueIdBinded)).m_142049_());
            }
        }
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.1f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11991_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11988_;
    }

    public void m_6043_() {
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    public static class PitcherTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityPitcher parentEntity;

        public PitcherTargetSelector(EntityPitcher guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            return !(p_apply_1_ instanceof EntityWinterHunter) && !(p_apply_1_ instanceof Wolf) && !(p_apply_1_ instanceof EntityPitcher);
        }
    }
}

