/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityRogue
extends Monster {
    public EntityRogue(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 6;
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return Monster.m_33017_(type, (ServerLevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean haveRobbedItem() {
        return !this.m_6844_(EquipmentSlot.OFFHAND).m_41619_();
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        if (this.m_21187_().nextInt(2) == 0) {
            this.m_8061_(EquipmentSlot.CHEST, DyeableLeatherItem.m_41118_((ItemStack)new ItemStack((ItemLike)Items.f_42408_), Arrays.asList((DyeItem)Items.f_42498_)));
            this.m_8061_(EquipmentSlot.LEGS, DyeableLeatherItem.m_41118_((ItemStack)new ItemStack((ItemLike)Items.f_42462_), Arrays.asList((DyeItem)Items.f_42498_)));
            this.m_8061_(EquipmentSlot.FEET, DyeableLeatherItem.m_41118_((ItemStack)new ItemStack((ItemLike)Items.f_42463_), Arrays.asList((DyeItem)Items.f_42498_)));
        }
        this.m_21409_(EquipmentSlot.OFFHAND, 2.0f);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 0.3).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public boolean m_7327_(Entity entityIn) {
        Player player;
        ItemStack stackOnHand;
        boolean flag = super.m_7327_(entityIn);
        if (flag && entityIn instanceof Player && !(stackOnHand = (player = (Player)entityIn).m_150109_().m_36056_()).m_41619_() && !this.haveRobbedItem()) {
            ItemStack robbedStack = stackOnHand.m_41777_();
            robbedStack.m_41764_(1);
            this.m_8061_(EquipmentSlot.OFFHAND, robbedStack);
            stackOnHand.m_41774_(1);
            this.m_21530_();
        }
        return flag;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_6851_(difficultyIn);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private boolean shouldRun(Player player) {
        Vec3 Vec32 = player.m_20252_(1.0f).m_82541_();
        Vec3 Vec31 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_142469_().f_82289_ + (double)this.m_20192_() - (player.m_20186_() + (double)player.m_20192_()), this.m_20189_() - player.m_20189_());
        double d0 = Vec31.m_82553_();
        double d1 = Vec32.m_82526_(Vec31 = Vec31.m_82541_());
        return d1 > 0.6 ? player.m_142582_((Entity)this) : false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EntityAIEscape(this, 2.25, 16.0f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 1.0) {
                this.m_20260_(true);
                this.m_6858_(false);
            } else if (d0 == 2.5) {
                this.m_20260_(false);
                this.m_6858_(true);
            } else {
                this.m_20260_(true);
                this.m_6858_(false);
            }
        } else {
            this.m_20260_(true);
            this.m_6858_(false);
        }
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    static class EntityAIEscape
    extends MoveTowardsTargetGoal {
        EntityRogue rogue;

        public EntityAIEscape(EntityRogue creature, double speedIn, float targetMaxDistance) {
            super((PathfinderMob)creature, speedIn, targetMaxDistance);
            this.rogue = creature;
        }

        public boolean m_8036_() {
            LivingEntity target = this.rogue.m_5448_();
            if (target instanceof Player && target != null && this.rogue.shouldRun((Player)target)) {
                return super.m_8036_();
            }
            return false;
        }
    }
}

