/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;

public class EntitySlimond
extends Monster {
    public EntitySlimond(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected ResourceLocation m_7582_() {
        return DungeonsModConfig.COMMON.slimond.getDefaultLootTable();
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return randomIn.nextInt(100) == 0 && Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
        this.m_7327_((Entity)entityIn);
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        this.m_7327_(entityIn);
    }

    public boolean m_7327_(Entity entityIn) {
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        int i = 0;
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            i += EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19380_(), f);
        return flag;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, true, null));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 20.0);
    }

    public int getJumpDelay() {
        return 20;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float m_6118_() {
        return 0.42f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.3f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12391_;
    }

    public SoundEvent getJumpSound() {
        return SoundEvents.f_12387_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final EntitySlimond slime;
        private boolean isAggressive;

        public MoveHelperController(EntitySlimond slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_() * 0.2f, 1.0f);
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class FloatGoal
    extends Goal {
        private final EntitySlimond slime;

        public FloatGoal(EntitySlimond slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (this.slime.m_21187_().nextFloat() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.2);
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntitySlimond slime;
        private int inflateTieredTimer;

        public AttackGoal(EntitySlimond slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_ ? false : this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8056_() {
            this.inflateTieredTimer = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) {
                return false;
            }
            return --this.inflateTieredTimer > 0;
        }

        public void m_8037_() {
            this.slime.m_21391_((Entity)this.slime.m_5448_(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.canDamagePlayer());
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntitySlimond slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntitySlimond slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.f_19861_ || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.m_21187_().nextInt(60);
                this.chosenDegrees = this.slime.m_21187_().nextInt(360);
            }
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class HopGoal
    extends Goal {
        private final EntitySlimond slime;

        public HopGoal(EntitySlimond slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.0);
        }
    }
}

