/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;

public class EntityWhirlwind
extends Monster {
    public EntityWhirlwind(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_19811_ = true;
        this.f_21364_ = 10;
    }

    public static boolean canSpawn(EntityType<? extends Monster> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return Monster.m_33023_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19378_()) {
            return super.m_6469_(source, amount);
        }
        if (source.m_7639_() instanceof EntityWhirlwind && !this.f_19853_.f_46443_) {
            return super.m_6469_(source, amount);
        }
        if (source.m_7639_() instanceof Player) {
            Player player = (Player)source.m_7639_();
            if (player.m_21205_().canPerformAction(ToolActions.SHOVEL_DIG)) {
                return super.m_6469_(source, amount);
            }
            return super.m_6469_(source, amount * 0.1f);
        }
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.m_21153_(this.m_21233_() / 4.0f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8107_() {
        super.m_8107_();
        AABB box = this.m_142469_().m_82400_(20.0);
        List nearEntities = this.f_19853_.m_45976_(Entity.class, box);
        if (!nearEntities.isEmpty()) {
            for (Entity nearEntity : nearEntities) {
                Vec3 direction = this.m_20182_().m_82546_(nearEntity.m_20182_());
                if (direction.m_82553_() == 0.0 || !this.m_142582_(nearEntity)) continue;
                double invDistance = 1.0 / direction.m_82553_() * (double)(this.m_21223_() / this.m_21233_());
                nearEntity.m_20256_(nearEntity.m_20184_().m_82549_(direction.m_82541_().m_82542_(invDistance, invDistance, invDistance)));
            }
        }
        if (this.f_19797_ % 600 == 0) {
            this.m_5634_(1.0f);
        }
    }

    public boolean m_7337_(Entity entity) {
        if (entity instanceof ItemEntity) {
            this.m_7327_((Entity)this);
        }
        return super.m_7337_(entity);
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11795_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12553_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12540_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }
}

